/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator;

import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ModuleUtils;
import org.apache.struts.util.RequestUtils;

public class Resources {
    private static String SERVLET_CONTEXT_PARAM;
    public static String SERVLET_CONTEXT_KEY;
    private static String HTTP_SERVLET_REQUEST_PARAM;
    public static String HTTP_SERVLET_REQUEST_KEY;
    private static String ACTION_MESSAGES_PARAM;
    public static String ACTION_ERRORS_KEY;

    public static ValidatorResources getValidatorResources(ServletContext application, HttpServletRequest request) {
        String prefix = ModuleUtils.getInstance().getModuleConfig(request, application).getPrefix();
        return (ValidatorResources)application.getAttribute("org.apache.commons.validator.VALIDATOR_RESOURCES" + prefix);
    }

    public static MessageResources getMessageResources(HttpServletRequest request) {
        return (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
    }

    public static MessageResources getMessageResources(ServletContext application, HttpServletRequest request, String bundle) {
        MessageResources resources;
        if (bundle == null) {
            bundle = "org.apache.struts.action.MESSAGE";
        }
        if ((resources = (MessageResources)request.getAttribute(bundle)) == null) {
            ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(request, application);
            resources = (MessageResources)application.getAttribute(bundle + moduleConfig.getPrefix());
        }
        if (resources == null) {
            resources = (MessageResources)application.getAttribute(bundle);
        }
        if (resources == null) {
            throw new NullPointerException("No message resources found for bundle: " + bundle);
        }
        return resources;
    }

    public static Locale getLocale(HttpServletRequest request) {
        return RequestUtils.getUserLocale(request, null);
    }

    public static String getMessage(MessageResources messages, Locale locale, String key) {
        String message = null;
        if (messages != null) {
            message = messages.getMessage(locale, key);
        }
        return message == null ? "" : message;
    }

    public static String getMessage(HttpServletRequest request, String key) {
        MessageResources messages = Resources.getMessageResources(request);
        return Resources.getMessage(messages, RequestUtils.getUserLocale(request, null), key);
    }

    public static String getMessage(MessageResources messages, Locale locale, ValidatorAction va, Field field) {
        Object[] args = Resources.getArgs(va.getName(), messages, locale, field);
        String msg = field.getMsg(va.getName()) != null ? field.getMsg(va.getName()) : va.getMsg();
        return messages.getMessage(locale, msg, args);
    }

    public static String getMessage(ServletContext application, HttpServletRequest request, MessageResources defaultMessages, Locale locale, ValidatorAction va, Field field) {
        Msg msg = field.getMessage(va.getName());
        if (msg != null && !msg.isResource()) {
            return msg.getKey();
        }
        String msgKey = null;
        String msgBundle = null;
        MessageResources messages = defaultMessages;
        if (msg == null) {
            msgKey = va.getMsg();
        } else {
            msgKey = msg.getKey();
            msgBundle = msg.getBundle();
            if (msg.getBundle() != null) {
                messages = Resources.getMessageResources(application, request, msg.getBundle());
            }
        }
        if (msgKey == null || msgKey.length() == 0) {
            return "??? " + va.getName() + "." + field.getProperty() + " ???";
        }
        Arg[] args = field.getArgs(va.getName());
        Object[] argValues = Resources.getArgValues(application, request, messages, locale, args);
        return messages.getMessage(locale, msgKey, argValues);
    }

    public static ActionError getActionError(HttpServletRequest request, ValidatorAction va, Field field) {
        Object[] args = Resources.getArgs(va.getName(), Resources.getMessageResources(request), RequestUtils.getUserLocale(request, null), field);
        String msg = field.getMsg(va.getName()) != null ? field.getMsg(va.getName()) : va.getMsg();
        return new ActionError(msg, args);
    }

    public static ActionMessage getActionMessage(HttpServletRequest request, ValidatorAction va, Field field) {
        Object[] args = Resources.getArgs(va.getName(), Resources.getMessageResources(request), RequestUtils.getUserLocale(request, null), field);
        String msg = field.getMsg(va.getName()) != null ? field.getMsg(va.getName()) : va.getMsg();
        return new ActionMessage(msg, args);
    }

    public static ActionMessage getActionMessage(Validator validator, HttpServletRequest request, ValidatorAction va, Field field) {
        Msg msg = field.getMessage(va.getName());
        if (msg != null && !msg.isResource()) {
            return new ActionMessage(msg.getKey(), false);
        }
        String msgKey = null;
        String msgBundle = null;
        if (msg == null) {
            msgKey = va.getMsg();
        } else {
            msgKey = msg.getKey();
            msgBundle = msg.getBundle();
        }
        if (msgKey == null || msgKey.length() == 0) {
            return new ActionMessage("??? " + va.getName() + "." + field.getProperty() + " ???", false);
        }
        ServletContext application = (ServletContext)validator.getParameterValue(SERVLET_CONTEXT_PARAM);
        MessageResources messages = Resources.getMessageResources(application, request, msgBundle);
        Locale locale = RequestUtils.getUserLocale(request, null);
        Arg[] args = field.getArgs(va.getName());
        Object[] argValues = Resources.getArgValues(application, request, messages, locale, args);
        ActionMessage actionMessage = null;
        if (msgBundle == null) {
            actionMessage = new ActionMessage(msgKey, argValues);
        } else {
            String message = messages.getMessage(locale, msgKey, argValues);
            actionMessage = new ActionMessage(message, false);
        }
        return actionMessage;
    }

    public static String[] getArgs(String actionName, MessageResources messages, Locale locale, Field field) {
        String[] argMessages = new String[4];
        Arg[] args = new Arg[]{field.getArg(actionName, 0), field.getArg(actionName, 1), field.getArg(actionName, 2), field.getArg(actionName, 3)};
        int i = 0;
        while (i < args.length) {
            if (args[i] != null) {
                argMessages[i] = args[i].isResource() ? Resources.getMessage(messages, locale, args[i].getKey()) : args[i].getKey();
            }
            ++i;
        }
        return argMessages;
    }

    private static String[] getArgValues(ServletContext application, HttpServletRequest request, MessageResources defaultMessages, Locale locale, Arg[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        String[] values = new String[args.length];
        int i = 0;
        while (i < args.length) {
            if (args[i] != null) {
                if (args[i].isResource()) {
                    MessageResources messages = defaultMessages;
                    if (args[i].getBundle() != null) {
                        messages = Resources.getMessageResources(application, request, args[i].getBundle());
                    }
                    values[i] = messages.getMessage(locale, args[i].getKey());
                } else {
                    values[i] = args[i].getKey();
                }
            }
            ++i;
        }
        return values;
    }

    public static Validator initValidator(String key, Object bean, ServletContext application, HttpServletRequest request, ActionMessages errors, int page) {
        ValidatorResources resources = Resources.getValidatorResources(application, request);
        Locale locale = RequestUtils.getUserLocale(request, null);
        Validator validator = new Validator(resources, key);
        validator.setUseContextClassLoader(true);
        validator.setPage(page);
        validator.setParameter(SERVLET_CONTEXT_PARAM, application);
        validator.setParameter(HTTP_SERVLET_REQUEST_PARAM, request);
        validator.setParameter("java.util.Locale", locale);
        validator.setParameter(ACTION_MESSAGES_PARAM, errors);
        validator.setParameter("java.lang.Object", bean);
        return validator;
    }

    static {
        SERVLET_CONTEXT_KEY = SERVLET_CONTEXT_PARAM = "javax.servlet.ServletContext";
        HTTP_SERVLET_REQUEST_KEY = HTTP_SERVLET_REQUEST_PARAM = "javax.servlet.http.HttpServletRequest";
        ACTION_ERRORS_KEY = ACTION_MESSAGES_PARAM = "org.apache.struts.action.ActionMessages";
    }
}

