/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.jersey;

import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.RestClientException;
import com.atlassian.jira.rest.client.SearchRestClient;
import com.atlassian.jira.rest.client.domain.SearchResult;
import com.atlassian.jira.rest.client.internal.jersey.AbstractJerseyRestClient;
import com.atlassian.jira.rest.client.internal.json.SearchResultJsonParser;
import com.sun.jersey.client.apache.ApacheHttpClient;
import java.net.URI;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JerseySearchRestClient
extends AbstractJerseyRestClient
implements SearchRestClient {
    private static final String START_AT_ATTRIBUTE = "startAt";
    private static final String MAX_RESULTS_ATTRIBUTE = "maxResults";
    private static final int MAX_JQL_LENGTH_FOR_HTTP_GET = 500;
    private static final String JQL_ATTRIBUTE = "jql";
    private final SearchResultJsonParser searchResultJsonParser = new SearchResultJsonParser();
    private static final String SEARCH_URI_PREFIX = "search";
    private final URI searchUri;

    public JerseySearchRestClient(URI baseUri, ApacheHttpClient client) {
        super(baseUri, client);
        this.searchUri = UriBuilder.fromUri(baseUri).path(SEARCH_URI_PREFIX).build(new Object[0]);
    }

    @Override
    public SearchResult searchJql(@Nullable String jql, ProgressMonitor progressMonitor) {
        if (jql == null) {
            jql = "";
        }
        if (jql.length() > 500) {
            JSONObject postEntity = new JSONObject();
            try {
                postEntity.put(JQL_ATTRIBUTE, jql);
            }
            catch (JSONException e) {
                throw new RestClientException(e);
            }
            return this.postAndParse(this.searchUri, postEntity, this.searchResultJsonParser, progressMonitor);
        }
        URI uri = UriBuilder.fromUri(this.searchUri).queryParam(JQL_ATTRIBUTE, jql).build(new Object[0]);
        return this.getAndParse(uri, this.searchResultJsonParser, progressMonitor);
    }

    @Override
    public SearchResult searchJql(@Nullable String jql, int maxResults, int startAt, ProgressMonitor progressMonitor) {
        if (jql == null) {
            jql = "";
        }
        if (jql.length() > 500) {
            JSONObject postEntity = new JSONObject();
            try {
                postEntity.put(JQL_ATTRIBUTE, jql);
                postEntity.put(START_AT_ATTRIBUTE, startAt);
                postEntity.put(MAX_RESULTS_ATTRIBUTE, maxResults);
            }
            catch (JSONException e) {
                throw new RestClientException(e);
            }
            return this.postAndParse(this.searchUri, postEntity, this.searchResultJsonParser, progressMonitor);
        }
        URI uri = UriBuilder.fromUri(this.searchUri).queryParam(JQL_ATTRIBUTE, jql).queryParam(MAX_RESULTS_ATTRIBUTE, maxResults).queryParam(START_AT_ATTRIBUTE, startAt).build(new Object[0]);
        return this.getAndParse(uri, this.searchResultJsonParser, progressMonitor);
    }
}

