/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.domain.input;

import com.atlassian.jira.rest.client.domain.EntityHelper;
import com.atlassian.jira.rest.client.domain.input.FieldInput;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;

public class IssueInput {
    private final Map<String, FieldInput> fields;

    public static IssueInput createWithFields(FieldInput ... fields) {
        return new IssueInput(Maps.uniqueIndex(ImmutableList.copyOf(fields), EntityHelper.GET_ENTITY_STRING_ID_FUNCTION));
    }

    public IssueInput(Map<String, FieldInput> fields) {
        this.fields = fields;
    }

    public Map<String, FieldInput> getFields() {
        return this.fields;
    }

    public FieldInput getField(String id) {
        return this.fields.get(id);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("fields", this.fields).toString();
    }
}

