/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira;

import com.atlassian.jira.rest.client.AuthenticationHandler;
import com.atlassian.jira.rest.client.JiraRestClient;
import com.atlassian.jira.rest.client.JiraRestClientFactory;
import com.atlassian.jira.rest.client.NullProgressMonitor;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.auth.AnonymousAuthenticationHandler;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.Transition;
import com.atlassian.jira.rest.client.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.internal.jersey.JerseyJiraRestClientFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.core.utils.ThreadCategory;

public class JiraTicketerPlugin
implements Plugin {
    protected final JiraRestClientFactory clientFactory = new JerseyJiraRestClientFactory();

    protected JiraRestClient getConnection() {
        try {
            URI jiraUri = new URL(JiraTicketerPlugin.getProperties().getProperty("jira.host")).toURI();
            String username = JiraTicketerPlugin.getProperties().getProperty("jira.username");
            if (username == null || "".equals(username)) {
                return this.clientFactory.create(jiraUri, (AuthenticationHandler)new AnonymousAuthenticationHandler());
            }
            return this.clientFactory.createWithBasicHttpAuthentication(jiraUri, JiraTicketerPlugin.getProperties().getProperty("jira.username"), JiraTicketerPlugin.getProperties().getProperty("jira.password"));
        }
        catch (MalformedURLException e) {
            JiraTicketerPlugin.log().error("Failed to parse URL: " + JiraTicketerPlugin.getProperties().getProperty("jira.host"));
        }
        catch (URISyntaxException e) {
            JiraTicketerPlugin.log().error("Failed to parse URI: " + JiraTicketerPlugin.getProperties().getProperty("jira.host"));
        }
        return null;
    }

    public Ticket get(String ticketId) {
        JiraRestClient jira = this.getConnection();
        if (jira == null) {
            return null;
        }
        Issue issue = jira.getIssueClient().getIssue(ticketId, (ProgressMonitor)new NullProgressMonitor());
        if (issue != null) {
            Ticket ticket = new Ticket();
            ticket.setId(issue.getKey());
            ticket.setModificationTimestamp(String.valueOf(issue.getUpdateDate().toDate().getTime()));
            ticket.setSummary(issue.getSummary());
            String allComments = "";
            for (Comment comment : issue.getComments()) {
                allComments = allComments + "\n" + comment.getAuthor().getDisplayName() + "\n" + comment.getBody();
            }
            ticket.setDetails(allComments.trim());
            ticket.setState(JiraTicketerPlugin.getStateFromId(issue.getStatus().getName()));
            return ticket;
        }
        return null;
    }

    private static Ticket.State getStateFromId(String stateIdString) {
        if (stateIdString == null) {
            return Ticket.State.OPEN;
        }
        if ("Open".equals(stateIdString)) {
            return Ticket.State.OPEN;
        }
        if ("In Progress".equals(stateIdString)) {
            return Ticket.State.OPEN;
        }
        if ("Reopened".equals(stateIdString)) {
            return Ticket.State.OPEN;
        }
        if ("Resolved".equals(stateIdString)) {
            return Ticket.State.CLOSED;
        }
        if ("Closed".equals(stateIdString)) {
            return Ticket.State.CLOSED;
        }
        return Ticket.State.OPEN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties() {
        File home = new File(System.getProperty("opennms.home"));
        File etc = new File(home, "etc");
        File config = new File(etc, "jira.properties");
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(config);
            props.load(in);
        }
        catch (IOException e) {
            try {
                JiraTicketerPlugin.log().error("Unable to load " + config + " ignoring.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((InputStream)in);
        JiraTicketerPlugin.log().debug("Loaded user: " + props.getProperty("jira.username"));
        JiraTicketerPlugin.log().debug("Loaded type: " + props.getProperty("jira.type"));
        return props;
    }

    public void saveOrUpdate(Ticket ticket) {
        JiraRestClient jira = this.getConnection();
        if (ticket.getId() == null || ticket.getId().equals("")) {
            IssueInputBuilder builder = new IssueInputBuilder(JiraTicketerPlugin.getProperties().getProperty("jira.project"), Long.valueOf(JiraTicketerPlugin.getProperties().getProperty("jira.type").trim()));
            builder.setReporterName(JiraTicketerPlugin.getProperties().getProperty("jira.username"));
            builder.setSummary(ticket.getSummary());
            builder.setDescription(ticket.getDetails());
            builder.setDueDate(new DateTime((Object)Calendar.getInstance()));
            jira.getIssueClient().createIssue(builder.build(), (ProgressMonitor)new NullProgressMonitor());
        } else {
            JiraTicketerPlugin.log().info("Received ticket: " + ticket.getId());
            Issue issue = jira.getIssueClient().getIssue(ticket.getId(), (ProgressMonitor)new NullProgressMonitor());
            Iterable transitions = jira.getIssueClient().getTransitions(issue, (ProgressMonitor)new NullProgressMonitor());
            if (Ticket.State.CLOSED.equals((Object)ticket.getState())) {
                Comment comment = Comment.valueOf((String)"Issue resolved by OpenNMS.");
                for (Transition transition : transitions) {
                    if (!"Resolve Issue".equals(transition.getName())) continue;
                    JiraTicketerPlugin.log().info("Resolving ticket " + ticket.getId());
                    jira.getIssueClient().transition(issue, new TransitionInput(transition.getId(), comment), (ProgressMonitor)new NullProgressMonitor());
                    return;
                }
                JiraTicketerPlugin.log().warn("Could not resolve ticket " + ticket.getId() + ", no \"Resolve Issue\" operation available.");
            } else if (Ticket.State.OPEN.equals((Object)ticket.getState())) {
                Comment comment = Comment.valueOf((String)"Issue reopened by OpenNMS.");
                for (Transition transition : transitions) {
                    if (!"Reopen Issue".equals(transition.getName())) continue;
                    JiraTicketerPlugin.log().info("Reopening ticket " + ticket.getId());
                    jira.getIssueClient().transition(issue, new TransitionInput(transition.getId(), comment), (ProgressMonitor)new NullProgressMonitor());
                    return;
                }
                JiraTicketerPlugin.log().warn("Could not reopen ticket " + ticket.getId() + ", no \"Reopen Issue\" operation available.");
            }
        }
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(JiraTicketerPlugin.class);
    }
}

