/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.httpclient.apache.httpcomponents.DefaultHttpClient;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.factory.HttpClientFactory;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.httpclient.spi.ThreadLocalContextManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.beans.factory.DisposableBean;

public final class DefaultHttpClientFactory
implements HttpClientFactory,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final ApplicationProperties applicationProperties;
    private final ThreadLocalContextManager threadLocalContextManager;
    private final Set<DefaultHttpClient> httpClients = new CopyOnWriteArraySet<DefaultHttpClient>();

    public DefaultHttpClientFactory(EventPublisher eventPublisher, ApplicationProperties applicationProperties, ThreadLocalContextManager threadLocalContextManager) {
        this.eventPublisher = Preconditions.checkNotNull(eventPublisher);
        this.applicationProperties = Preconditions.checkNotNull(applicationProperties);
        this.threadLocalContextManager = Preconditions.checkNotNull(threadLocalContextManager);
    }

    @Override
    public HttpClient create(HttpClientOptions options) {
        return this.doCreate(options, this.threadLocalContextManager);
    }

    @Override
    public HttpClient create(HttpClientOptions options, ThreadLocalContextManager threadLocalContextManager) {
        return this.doCreate(options, threadLocalContextManager);
    }

    private HttpClient doCreate(HttpClientOptions options, ThreadLocalContextManager threadLocalContextManager) {
        Preconditions.checkNotNull(options);
        DefaultHttpClient httpClient = new DefaultHttpClient(this.eventPublisher, this.applicationProperties, threadLocalContextManager, options);
        this.httpClients.add(httpClient);
        return httpClient;
    }

    public void destroy() throws Exception {
        for (DefaultHttpClient httpClient : this.httpClients) {
            httpClient.destroy();
        }
    }
}

