/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util.collection;

import com.google.common.base.Objects;
import org.glassfish.jersey.internal.util.collection.Ref;

public final class Refs {
    private Refs() {
    }

    public static <T> Ref<T> of(T value) {
        return new DefaultRefImpl<T>(value);
    }

    public static <T> Ref<T> emptyRef() {
        return new DefaultRefImpl();
    }

    public static <T> Ref<T> immutableRef(T value) {
        return new ImmutableRefImpl<T>(value);
    }

    private static final class DefaultRefImpl<T>
    implements Ref<T> {
        private T reference;

        public DefaultRefImpl() {
            this.reference = null;
        }

        public DefaultRefImpl(T value) {
            this.reference = value;
        }

        @Override
        public T get() {
            return this.reference;
        }

        @Override
        public void set(T value) throws IllegalStateException {
            this.reference = value;
        }

        public String toString() {
            return Objects.toStringHelper(this).add("reference", this.reference).toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DefaultRefImpl other = (DefaultRefImpl)obj;
            return this.reference == other.reference || this.reference != null && this.reference.equals(other.reference);
        }

        public int hashCode() {
            int hash = 5;
            hash = 47 * hash + (this.reference != null ? this.reference.hashCode() : 0);
            return hash;
        }
    }

    private static final class ImmutableRefImpl<T>
    implements Ref<T> {
        private final T reference;

        public ImmutableRefImpl(T value) {
            this.reference = value;
        }

        @Override
        public T get() {
            return this.reference;
        }

        @Override
        public void set(T value) throws IllegalStateException {
            throw new IllegalStateException("This implementation of Ref interface is immutable.");
        }

        public String toString() {
            return Objects.toStringHelper(this).add("reference", this.reference).toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImmutableRefImpl other = (ImmutableRefImpl)obj;
            return this.reference == other.reference || this.reference != null && this.reference.equals(other.reference);
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + (this.reference != null ? this.reference.hashCode() : 0);
            return hash;
        }
    }
}

