/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.client.methods;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentDecoderChannel;
import org.apache.http.nio.FileContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ZeroCopyConsumer<T>
extends AbstractAsyncResponseConsumer<T> {
    private final File file;
    private HttpResponse response;
    private ContentType contentType;
    private FileChannel fileChannel;
    private long idx = -1L;

    public ZeroCopyConsumer(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File may nor be null");
        }
        this.file = file;
    }

    @Override
    protected void onResponseReceived(HttpResponse response) {
        this.response = response;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        this.contentType = contentType;
        this.fileChannel = new FileOutputStream(this.file).getChannel();
        this.idx = 0L;
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        if (this.fileChannel == null) {
            throw new IllegalStateException("File channel is null");
        }
        long transferred = decoder instanceof FileContentDecoder ? ((FileContentDecoder)decoder).transfer(this.fileChannel, this.idx, Integer.MAX_VALUE) : this.fileChannel.transferFrom(new ContentDecoderChannel(decoder), this.idx, Integer.MAX_VALUE);
        if (transferred > 0L) {
            this.idx += transferred;
        }
        if (decoder.isCompleted()) {
            this.fileChannel.close();
            this.fileChannel = null;
        }
    }

    protected abstract T process(HttpResponse var1, File var2, ContentType var3) throws Exception;

    @Override
    protected T buildResult(HttpContext context) throws Exception {
        FileEntity entity = new FileEntity(this.file);
        entity.setContentType(this.response.getFirstHeader("Content-Type"));
        this.response.setEntity(entity);
        return this.process(this.response, this.file, this.contentType);
    }

    @Override
    protected void releaseResources() {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fileChannel = null;
        }
    }
}

