/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.httpclient.apache.httpcomponents.DefaultMessage;
import com.atlassian.httpclient.api.Response;
import java.io.InputStream;
import java.util.Map;

public final class DefaultResponse
extends DefaultMessage
implements Response {
    private int statusCode;
    private String statusText;

    public DefaultResponse(long maxEntitySize) {
        super(maxEntitySize);
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Response setStatusCode(int statusCode) {
        this.checkMutable();
        this.statusCode = statusCode;
        return this;
    }

    @Override
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public Response setStatusText(String statusText) {
        this.checkMutable();
        this.statusText = statusText;
        return this;
    }

    @Override
    public boolean isInformational() {
        return this.statusCode >= 100 && this.statusCode < 200;
    }

    @Override
    public boolean isSuccessful() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    @Override
    public boolean isOk() {
        return this.statusCode == 200;
    }

    @Override
    public boolean isCreated() {
        return this.statusCode == 201;
    }

    @Override
    public boolean isNoContent() {
        return this.statusCode == 204;
    }

    @Override
    public boolean isRedirection() {
        return this.statusCode >= 300 && this.statusCode < 400;
    }

    @Override
    public boolean isSeeOther() {
        return this.statusCode == 303;
    }

    @Override
    public boolean isNotModified() {
        return this.statusCode == 304;
    }

    @Override
    public boolean isClientError() {
        return this.statusCode >= 400 && this.statusCode < 500;
    }

    @Override
    public boolean isBadRequest() {
        return this.statusCode == 400;
    }

    @Override
    public boolean isUnauthorized() {
        return this.statusCode == 401;
    }

    @Override
    public boolean isForbidden() {
        return this.statusCode == 403;
    }

    @Override
    public boolean isNotFound() {
        return this.statusCode == 404;
    }

    @Override
    public boolean isConflict() {
        return this.statusCode == 409;
    }

    @Override
    public boolean isServerError() {
        return this.statusCode >= 500 && this.statusCode < 600;
    }

    @Override
    public boolean isInternalServerError() {
        return this.statusCode == 500;
    }

    @Override
    public boolean isServiceUnavailable() {
        return this.statusCode == 503;
    }

    @Override
    public boolean isError() {
        return this.isClientError() || this.isServerError();
    }

    @Override
    public boolean isNotSuccessful() {
        return this.isInformational() || this.isRedirection() || this.isError();
    }

    @Override
    public Response setContentType(String contentType) {
        this.checkMutable();
        super.setContentType(contentType);
        return this;
    }

    @Override
    public Response setContentCharset(String contentCharset) {
        this.checkMutable();
        super.setContentCharset(contentCharset);
        return this;
    }

    @Override
    public Response setHeaders(Map<String, String> headers) {
        this.checkMutable();
        super.setHeaders(headers);
        return this;
    }

    @Override
    public Response setHeader(String name, String value) {
        this.checkMutable();
        super.setHeader(name, value);
        return this;
    }

    @Override
    public Response setEntity(String entity) {
        this.checkMutable();
        super.setEntity(entity);
        return this;
    }

    @Override
    public Response setEntityStream(InputStream entityStream, String encoding) {
        this.checkMutable();
        super.setEntityStream(entityStream, encoding);
        return this;
    }

    @Override
    public Response setEntityStream(InputStream entityStream) {
        this.checkMutable();
        super.setEntityStream(entityStream);
        return this;
    }

    @Override
    protected Response freeze() {
        super.freeze();
        return this;
    }
}

