/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.api.domain.BasicUser;
import com.atlassian.jira.rest.client.api.domain.Filter;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import java.net.URI;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class FilterJsonParser
implements JsonObjectParser<Filter> {
    @Override
    public Filter parse(JSONObject json) throws JSONException {
        URI selfUri = JsonParseUtil.getSelfUri(json);
        long id = json.getLong("id");
        String name = json.getString("name");
        String jql = json.getString("jql");
        String description = json.optString("description");
        URI searchUrl = JsonParseUtil.parseURI(json.getString("searchUrl"));
        URI viewUrl = JsonParseUtil.parseURI(json.getString("viewUrl"));
        BasicUser owner = JsonParseUtil.parseBasicUser(json.getJSONObject("owner"));
        boolean favourite = json.getBoolean("favourite");
        return new Filter(selfUri, id, name, description, jql, viewUrl, searchUrl, owner, favourite);
    }
}

