/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.internal;

import com.atlassian.event.spi.ListenerInvoker;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SingleParameterMethodListenerInvoker
implements ListenerInvoker {
    private final Method method;
    private final Object listener;

    public SingleParameterMethodListenerInvoker(Object listener, Method method) {
        this.listener = Preconditions.checkNotNull(listener);
        this.method = Preconditions.checkNotNull(method);
    }

    @Override
    public Set<Class<?>> getSupportedEventTypes() {
        return Sets.newHashSet(this.method.getParameterTypes());
    }

    @Override
    public void invoke(Object event) {
        try {
            this.method.invoke(this.listener, event);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() == null) {
                throw new RuntimeException(e);
            }
            if (e.getCause().getMessage() == null) {
                throw new RuntimeException(e.getCause());
            }
            throw new RuntimeException(e.getCause().getMessage(), e.getCause());
        }
    }

    @Override
    public boolean supportAsynchronousEvents() {
        return true;
    }
}

