/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.client.methods;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncByteConsumer<T>
extends AbstractAsyncResponseConsumer<T> {
    private final int bufSize;
    private ByteBuffer bbuf;

    public AsyncByteConsumer(int bufSize) {
        this.bufSize = bufSize;
    }

    public AsyncByteConsumer() {
        this(8192);
    }

    protected abstract void onByteReceived(ByteBuffer var1, IOControl var2) throws IOException;

    @Override
    protected final void onEntityEnclosed(HttpEntity entity, ContentType contentType) {
        this.bbuf = ByteBuffer.allocate(this.bufSize);
    }

    @Override
    protected final void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        int bytesRead;
        if (this.bbuf == null) {
            throw new IllegalStateException("Byte buffer is null");
        }
        while ((bytesRead = decoder.read(this.bbuf)) > 0) {
            this.bbuf.flip();
            this.onByteReceived(this.bbuf, ioctrl);
            this.bbuf.clear();
        }
    }

    @Override
    protected void releaseResources() {
        this.bbuf = null;
    }
}

