/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal;

import com.google.common.collect.Maps;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.ClassTypePair;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.glassfish.jersey.spi.ExtendedExceptionMapper;

public class ExceptionMapperFactory
implements ExceptionMappers {
    private static final Logger LOGGER = Logger.getLogger(ExceptionMapperFactory.class.getName());
    private Set<ExceptionMapperType> exceptionMapperTypes = new LinkedHashSet<ExceptionMapperType>();

    @Override
    public <T extends Throwable> ExceptionMapper<T> findMapping(T exceptionInstance) {
        return this.find(exceptionInstance.getClass(), exceptionInstance);
    }

    @Override
    public <T extends Throwable> ExceptionMapper<T> find(Class<T> type) {
        return this.find(type, null);
    }

    private <T extends Throwable> ExceptionMapper<T> find(Class<T> type, T exceptionInstance) {
        TreeMap<Integer, ExceptionMapper> orderedMappers = Maps.newTreeMap();
        for (ExceptionMapperType mapperType : this.exceptionMapperTypes) {
            int d = this.distance(type, mapperType.exceptionType);
            if (d < 0) continue;
            orderedMappers.put(d, mapperType.mapper);
        }
        if (orderedMappers.size() == 0) {
            return null;
        }
        if (exceptionInstance != null) {
            for (ExceptionMapper mapper : orderedMappers.values()) {
                if (mapper instanceof ExtendedExceptionMapper) {
                    boolean mappable = ((ExtendedExceptionMapper)mapper).isMappable(exceptionInstance);
                    if (!mappable) continue;
                    return mapper;
                }
                return mapper;
            }
            return null;
        }
        return (ExceptionMapper)orderedMappers.values().iterator().next();
    }

    @Inject
    public ExceptionMapperFactory(ServiceLocator locator) {
        for (ExceptionMapper mapper : Providers.getAllProviders(locator, ExceptionMapper.class)) {
            Class<? extends Throwable> c = this.getExceptionType(mapper.getClass());
            if (c == null) continue;
            this.exceptionMapperTypes.add(new ExceptionMapperType(mapper, c));
        }
    }

    private int distance(Class<?> c, Class<?> emtc) {
        int distance = 0;
        if (!emtc.isAssignableFrom(c)) {
            return -1;
        }
        while (c != emtc) {
            c = c.getSuperclass();
            ++distance;
        }
        return distance;
    }

    private Class<? extends Throwable> getExceptionType(Class<? extends ExceptionMapper> c) {
        Class t = this.getType(c);
        if (Throwable.class.isAssignableFrom(t)) {
            return t;
        }
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning(LocalizationMessages.EXCEPTION_MAPPER_SUPPORTED_TYPE_UNKNOWN(c.getName()));
        }
        return null;
    }

    private Class getType(Class<? extends ExceptionMapper> c) {
        for (Class<? extends ExceptionMapper> _c = c; _c != Object.class; _c = _c.getSuperclass()) {
            Type[] ts;
            for (Type t : ts = _c.getGenericInterfaces()) {
                ParameterizedType pt;
                if (!(t instanceof ParameterizedType) || (pt = (ParameterizedType)t).getRawType() != ExceptionMapper.class && pt.getRawType() != ExtendedExceptionMapper.class) continue;
                return this.getResolvedType(pt.getActualTypeArguments()[0], c, _c);
            }
        }
        return null;
    }

    private Class getResolvedType(Type t, Class c, Class dc) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof TypeVariable) {
            ClassTypePair ct = ReflectionHelper.resolveTypeVariable(c, dc, (TypeVariable)t);
            if (ct != null) {
                return ct.rawClass();
            }
            return null;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            return (Class)pt.getRawType();
        }
        return null;
    }

    private static class ExceptionMapperType {
        ExceptionMapper mapper;
        Class<? extends Throwable> exceptionType;

        public ExceptionMapperType(ExceptionMapper mapper, Class<? extends Throwable> exceptionType) {
            this.mapper = mapper;
            this.exceptionType = exceptionType;
        }
    }

    public static class Binder
    extends AbstractBinder {
        @Override
        protected void configure() {
            this.bindAsContract(ExceptionMapperFactory.class).to(ExceptionMappers.class).in(Singleton.class);
        }
    }
}

