/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.httpclient.apache.httpcomponents.DefaultMessage;
import com.atlassian.httpclient.api.EntityBuilder;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.base.AbstractHttpClient;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Map;

public class DefaultRequest
extends DefaultMessage
implements Request {
    private AbstractHttpClient httpClient;
    private Request.Method method;
    private URI uri;
    private boolean cacheDisabled;
    private Map<String, String> attributes;

    public DefaultRequest(AbstractHttpClient httpClient) {
        this.httpClient = httpClient;
        this.attributes = Maps.newHashMap();
        this.setAccept("*/*");
    }

    public DefaultRequest(AbstractHttpClient httpClient, URI uri) {
        this(httpClient, uri, null, null);
    }

    public DefaultRequest(AbstractHttpClient httpClient, URI uri, String contentType, String entity) {
        this(httpClient);
        this.setUri(uri).setContentType(contentType).setEntity(entity);
    }

    @Override
    public ResponsePromise get() {
        this.setMethod(Request.Method.GET);
        return this.httpClient.execute(this);
    }

    @Override
    public ResponsePromise post() {
        this.setMethod(Request.Method.POST);
        return this.httpClient.execute(this);
    }

    @Override
    public ResponsePromise put() {
        this.setMethod(Request.Method.PUT);
        return this.httpClient.execute(this);
    }

    @Override
    public ResponsePromise delete() {
        this.setMethod(Request.Method.DELETE);
        return this.httpClient.execute(this);
    }

    @Override
    public ResponsePromise options() {
        this.setMethod(Request.Method.OPTIONS);
        return this.httpClient.execute(this);
    }

    @Override
    public ResponsePromise head() {
        this.setMethod(Request.Method.HEAD);
        return this.httpClient.execute(this);
    }

    @Override
    public ResponsePromise trace() {
        this.setMethod(Request.Method.TRACE);
        return this.httpClient.execute(this);
    }

    @Override
    public Request.Method getMethod() {
        return this.method;
    }

    private Request setMethod(Request.Method method) {
        this.checkMutable();
        this.method = method;
        return this;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Request setUri(URI uri) {
        this.checkMutable();
        this.uri = uri;
        return this;
    }

    @Override
    public String getAccept() {
        return this.getHeader("Accept");
    }

    @Override
    public Request setAccept(String accept) {
        this.checkMutable();
        this.setHeader("Accept", accept);
        return this;
    }

    @Override
    public Request setCacheDisabled() {
        this.checkMutable();
        this.cacheDisabled = true;
        return this;
    }

    @Override
    public Request setAttribute(String name, String value) {
        this.checkMutable();
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public Request setAttributes(Map<String, String> properties) {
        this.checkMutable();
        this.attributes.putAll(properties);
        return this;
    }

    @Override
    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Request setEntity(EntityBuilder entityBuilder) {
        EntityBuilder.Entity entity = entityBuilder.build();
        return this.setHeaders((Map)entity.getHeaders()).setEntityStream(entity.getInputStream());
    }

    @Override
    public Request validate() {
        super.validate();
        Preconditions.checkNotNull(this.uri);
        Preconditions.checkNotNull(this.method);
        switch (this.method) {
            case GET: 
            case DELETE: 
            case HEAD: {
                if (!this.hasEntity()) break;
                throw new IllegalStateException("Request method " + (Object)((Object)this.method) + " does not support an entity");
            }
            case POST: 
            case PUT: 
            case TRACE: {
                if (this.hasEntity()) break;
                throw new IllegalStateException("Request method " + (Object)((Object)this.method) + " requires an entity");
            }
        }
        return this;
    }

    @Override
    public Request setContentType(String contentType) {
        super.setContentType(contentType);
        return this;
    }

    @Override
    public Request setContentCharset(String contentCharset) {
        super.setContentCharset(contentCharset);
        return this;
    }

    @Override
    public Request setHeaders(Map<String, String> headers) {
        super.setHeaders(headers);
        return this;
    }

    @Override
    public Request setHeader(String name, String value) {
        super.setHeader(name, value);
        return this;
    }

    @Override
    public Request setEntity(String entity) {
        super.setEntity(entity);
        return this;
    }

    @Override
    public Request setEntityStream(InputStream entityStream, String encoding) {
        super.setEntityStream(entityStream, encoding);
        return this;
    }

    @Override
    public Request setEntityStream(InputStream entityStream) {
        super.setEntityStream(entityStream);
        return this;
    }

    public boolean isCacheDisabled() {
        return this.cacheDisabled;
    }

    @Override
    protected Request freeze() {
        super.freeze();
        return this;
    }
}

