/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.util.concurrent.FutureCallback;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DelegatingPromise<T>
implements Promise<T> {
    private final Promise<T> delegate;

    public DelegatingPromise(Promise<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T claim() {
        try {
            return this.delegate.claim();
        }
        catch (RestClientException e) {
            throw new RestClientException(e);
        }
    }

    @Override
    public Promise<T> done(Effect<T> e) {
        return this.delegate.done(e);
    }

    @Override
    public Promise<T> fail(Effect<Throwable> e) {
        return this.delegate.fail(e);
    }

    @Override
    public Promise<T> then(FutureCallback<T> callback) {
        return this.delegate.then(callback);
    }

    @Override
    public <B> Promise<B> map(Function<? super T, ? extends B> function) {
        return this.delegate.map(function);
    }

    @Override
    public <B> Promise<B> flatMap(Function<? super T, Promise<B>> function) {
        return this.delegate.flatMap(function);
    }

    @Override
    public Promise<T> recover(Function<Throwable, ? extends T> handleThrowable) {
        return this.delegate.recover(handleThrowable);
    }

    @Override
    public <B> Promise<B> fold(Function<Throwable, ? extends B> handleThrowable, Function<? super T, ? extends B> function) {
        return this.delegate.fold(handleThrowable, function);
    }

    @Override
    public void addListener(Runnable listener, Executor executor) {
        this.delegate.addListener(listener, executor);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return (T)this.delegate.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.get(timeout, unit);
    }
}

