/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain;

import com.atlassian.jira.rest.client.api.domain.Permission;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;

public class Permissions {
    public static final String WORK_ISSUE = "WORK_ISSUE";
    private final Map<String, Permission> permissionMap;

    public Permissions(Iterable<Permission> permissions) {
        this.permissionMap = Maps.uniqueIndex(permissions, Permission.TO_KEY);
    }

    public Map<String, Permission> getPermissionMap() {
        return this.permissionMap;
    }

    public boolean havePermission(String permissionKey) {
        Permission permission = this.getPermission(permissionKey);
        return permission != null && permission.havePermission();
    }

    @Nullable
    public Permission getPermission(String permissionKey) {
        return this.permissionMap.get(permissionKey);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("permissionMap", this.permissionMap).toString();
    }

    public boolean equals(Object o) {
        if (o instanceof Permissions) {
            Permissions that = (Permissions)o;
            return Objects.equal(this.permissionMap, that.permissionMap);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.permissionMap).hashCode();
    }
}

