/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.api;

import com.atlassian.httpclient.api.Response;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;

final class ResponsePromiseMapFunction<O>
implements Function<Response, O> {
    private final Map<StatusRange, Function<Response, ? extends O>> functions = Maps.newHashMap();
    private Function<Response, ? extends O> othersFunction;

    ResponsePromiseMapFunction() {
    }

    public void addStatusRangeFunction(StatusRange range, Function<Response, ? extends O> func) {
        this.functions.put(range, func);
    }

    public void setOthersFunction(Function<Response, ? extends O> othersFunction) {
        this.othersFunction = othersFunction;
    }

    @Override
    public O apply(Response response) {
        final int statusCode = response.getStatusCode();
        Map<StatusRange, Function<Response, O>> matchingFunctions = Maps.filterKeys(this.functions, new Predicate<StatusRange>(){

            @Override
            public boolean apply(StatusRange input) {
                return input.isIn(statusCode);
            }
        });
        if (matchingFunctions.isEmpty()) {
            if (this.othersFunction != null) {
                return this.othersFunction.apply(response);
            }
            throw new IllegalStateException("Could not match any function to status " + statusCode);
        }
        if (matchingFunctions.size() > 1) {
            throw new IllegalStateException("Found multiple functions for status " + statusCode);
        }
        return Iterables.getLast(matchingFunctions.values()).apply(response);
    }

    static interface StatusRange {
        public boolean isIn(int var1);
    }
}

