/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.bulk;

import io.searchbox.core.BulkResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.plugins.elasticsearch.rest.bulk.BulkResultWrapper;
import org.opennms.plugins.elasticsearch.rest.bulk.BulkUtils;
import org.opennms.plugins.elasticsearch.rest.bulk.FailedItem;

public class DefaultBulkResult<T>
implements BulkResultWrapper {
    private final BulkResult rawResult;
    private final List<T> documents;

    public DefaultBulkResult(BulkResult raw, List<T> documents) {
        this.rawResult = Objects.requireNonNull(raw);
        this.documents = new ArrayList<T>((Collection)Objects.requireNonNull(documents));
    }

    @Override
    public boolean isSucceeded() {
        return this.rawResult.isSucceeded();
    }

    @Override
    public String getErrorMessage() {
        return this.rawResult.getErrorMessage();
    }

    @Override
    public List<FailedItem<T>> getFailedItems() {
        int j = 0;
        ArrayList<FailedItem<T>> failedItems = new ArrayList<FailedItem<T>>();
        for (int i = 0; i < this.rawResult.getItems().size(); ++i) {
            BulkResult.BulkResultItem bulkResultItem = (BulkResult.BulkResultItem)this.rawResult.getItems().get(i);
            if (bulkResultItem.error == null || bulkResultItem.error.isEmpty()) continue;
            Exception cause = BulkUtils.convertToException(bulkResultItem.error);
            T failedObject = this.documents.get(j);
            FailedItem<T> failedItem = new FailedItem<T>(j, failedObject, cause);
            failedItems.add(failedItem);
            ++j;
        }
        return failedItems;
    }

    @Override
    public BulkResult getRawResult() {
        return this.rawResult;
    }

    @Override
    public List<T> getFailedDocuments() {
        return this.getFailedItems().stream().map(item -> item.getItem()).collect(Collectors.toList());
    }
}

