/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jest.client.template;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.Ping;
import io.searchbox.indices.template.PutTemplate;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.features.jest.client.ConnectionPoolShutdownException;
import org.opennms.features.jest.client.template.CachingTemplateLoader;
import org.opennms.features.jest.client.template.IndexSettings;
import org.opennms.features.jest.client.template.MergingTemplateLoader;
import org.opennms.features.jest.client.template.OsgiTemplateLoader;
import org.opennms.features.jest.client.template.TemplateInitializer;
import org.opennms.features.jest.client.template.TemplateLoader;
import org.opennms.features.jest.client.template.Version;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTemplateInitializer
implements TemplateInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTemplateInitializer.class);
    private static final long[] COOL_DOWN_TIMES_IN_MS = new long[]{250L, 500L, 1000L, 5000L, 10000L, 60000L};
    private final AtomicInteger retryCount = new AtomicInteger(0);
    private final JestClient client;
    private final TemplateLoader templateLoader;
    private final String templateLocation;
    private final String templateName;
    private final IndexSettings indexSettings;
    private boolean initialized;

    public DefaultTemplateInitializer(BundleContext bundleContext, JestClient client, String templateLocation, String templateName) {
        this(client, templateLocation, templateName, new CachingTemplateLoader(new OsgiTemplateLoader(bundleContext)), new IndexSettings());
    }

    public DefaultTemplateInitializer(BundleContext bundleContext, JestClient client, String templateLocation, String templateName, IndexSettings indexSettings) {
        this(client, templateLocation, templateName, new CachingTemplateLoader(new MergingTemplateLoader(new OsgiTemplateLoader(bundleContext), indexSettings)), indexSettings);
    }

    protected DefaultTemplateInitializer(JestClient client, String templateLocation, String templateName, TemplateLoader templateLoader, IndexSettings indexSettings) {
        this.client = Objects.requireNonNull(client);
        this.templateLocation = templateLocation;
        this.templateName = Objects.requireNonNull(templateName);
        this.templateLoader = Objects.requireNonNull(templateLoader);
        this.indexSettings = Objects.requireNonNull(indexSettings);
    }

    @Override
    public synchronized void initialize() {
        while (!this.initialized && !Thread.interrupted()) {
            try {
                LOG.debug("Template {} is not initialized. Initializing...", (Object)this.templateName);
                this.doInitialize();
                this.initialized = true;
            }
            catch (ConnectionPoolShutdownException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LOG.error("An error occurred while initializing template {}: {}.", new Object[]{this.templateName, ex.getMessage(), ex});
                long coolDownTimeInMs = COOL_DOWN_TIMES_IN_MS[this.retryCount.get()];
                LOG.debug("Retrying in {} ms", (Object)coolDownTimeInMs);
                this.waitBeforeRetrying(coolDownTimeInMs);
                if (this.retryCount.get() == COOL_DOWN_TIMES_IN_MS.length - 1) continue;
                this.retryCount.incrementAndGet();
            }
        }
    }

    @Override
    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    private void waitBeforeRetrying(long cooldown) {
        try {
            Thread.sleep(cooldown);
        }
        catch (InterruptedException e) {
            LOG.warn("Sleep was interrupted", (Throwable)e);
        }
    }

    private void doInitialize() throws IOException {
        PutTemplate putTemplate;
        JestResult result;
        Version version = this.getServerVersion();
        String template = this.templateLoader.load(version, this.templateLocation);
        String effectiveTemplateName = this.templateName;
        if (this.indexSettings.getIndexPrefix() != null) {
            effectiveTemplateName = this.indexSettings.getIndexPrefix() + this.templateName;
        }
        if (!(result = this.client.execute((Action)(putTemplate = new PutTemplate.Builder(effectiveTemplateName, (Object)template).build()))).isSucceeded()) {
            throw new IllegalStateException("Template '" + this.templateName + "' could not be persisted. Reason: " + result.getErrorMessage());
        }
    }

    private Version getServerVersion() throws IOException {
        Ping ping = new Ping.Builder().build();
        JestResult result = this.client.execute((Action)ping);
        if (!result.isSucceeded()) {
            throw new IllegalStateException("Ping failed. Template '" + this.templateName + "' will not be persisted. Reason: " + result.getErrorMessage());
        }
        JsonObject responseJson = result.getJsonObject();
        JsonObject versionDetails = responseJson.getAsJsonObject("version");
        if (versionDetails == null) {
            throw new IllegalStateException("Ping response does not contain version: " + responseJson);
        }
        JsonElement versionEl = versionDetails.get("number");
        if (versionEl == null) {
            throw new IllegalStateException("Ping response does not contain version number: " + responseJson);
        }
        String versionNumber = versionEl.getAsString();
        return Version.fromVersionString(versionNumber);
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }
}

