/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jest.client.index;

import java.util.ArrayList;
import java.util.List;

public class StringCollapser {
    private List<String> list;
    private int collapseAfter;
    private boolean doCollapsingAtBeginning = true;
    private boolean doCollapsingAtEnd = true;
    private String wildcard = "*";

    private StringCollapser(List<String> list) {
        this.list = list;
    }

    public static StringCollapser forList(List<String> list) {
        return new StringCollapser(list);
    }

    public StringCollapser doCollapsingAtBeginning(boolean doCollapsingAtBeginning) {
        this.doCollapsingAtBeginning = doCollapsingAtBeginning;
        return this;
    }

    public StringCollapser doCollapsingAtEnd(boolean doCollapsingAtEnd) {
        this.doCollapsingAtEnd = doCollapsingAtEnd;
        return this;
    }

    public StringCollapser collapseAfterChars(int collapseAfter) {
        this.collapseAfter = collapseAfter;
        return this;
    }

    public StringCollapser replaceCollapsedCharsWith(String wildcard) {
        this.wildcard = wildcard;
        return this;
    }

    public List<String> collapse() {
        if (this.list == null || this.list.size() == 0) {
            return this.list;
        }
        String currentStem = null;
        String firstStem = this.list.get(0).substring(0, this.collapseAfter);
        String lastStem = this.list.get(this.list.size() - 1).substring(0, this.collapseAfter);
        ArrayList<String> result = new ArrayList<String>();
        boolean currentStemAdded = false;
        for (String element : this.list) {
            if (!element.substring(0, this.collapseAfter).equals(currentStem)) {
                currentStem = element.substring(0, this.collapseAfter);
                currentStemAdded = false;
            }
            boolean doCollapsing = true;
            if (firstStem.equals(currentStem) && !this.doCollapsingAtBeginning) {
                doCollapsing = false;
            }
            if (!lastStem.equals(firstStem) && lastStem.equals(currentStem) && !this.doCollapsingAtEnd) {
                doCollapsing = false;
            }
            if (doCollapsing && !currentStemAdded) {
                result.add(currentStem + this.wildcard);
                currentStemAdded = true;
                continue;
            }
            if (doCollapsing) continue;
            result.add(element);
            currentStemAdded = false;
        }
        return result;
    }
}

