/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.index;

import org.opennms.plugins.elasticsearch.rest.index.IndexStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexStrategyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(IndexStrategyFactory.class);
    private static final IndexStrategy DEFAULT_INDEX = IndexStrategy.MONTHLY;

    public static IndexStrategy createIndexStrategy(String input) {
        for (IndexStrategy strategy : IndexStrategy.values()) {
            if (!strategy.name().equalsIgnoreCase(input)) continue;
            LOG.debug("Using strategy {}", (Object)strategy);
            return strategy;
        }
        LOG.debug("No strategy found for key {}, falling back to {}", (Object)input, (Object)DEFAULT_INDEX);
        return DEFAULT_INDEX;
    }
}

