/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.template;

import java.io.IOException;
import java.util.Objects;
import org.opennms.plugins.elasticsearch.rest.template.IndexSettings;
import org.opennms.plugins.elasticsearch.rest.template.TemplateLoader;
import org.opennms.plugins.elasticsearch.rest.template.TemplateMerger;
import org.opennms.plugins.elasticsearch.rest.template.Version;

public class MergingTemplateLoader
implements TemplateLoader {
    private final TemplateLoader delegate;
    private final IndexSettings indexSettings;

    public MergingTemplateLoader(TemplateLoader delegate, IndexSettings indexSettings) {
        this.delegate = Objects.requireNonNull(delegate);
        this.indexSettings = indexSettings;
    }

    @Override
    public String load(Version serverVersion, String resource) throws IOException {
        String template = this.delegate.load(serverVersion, resource);
        return this.merge(template);
    }

    private String merge(String template) {
        String mergedTemplate = new TemplateMerger().merge(template, this.indexSettings);
        return mergedTemplate;
    }
}

