/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.index;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.opennms.plugins.elasticsearch.rest.index.IndexStrategy;
import org.opennms.plugins.elasticsearch.rest.index.StringCollapser;

public class IndexSelector {
    private static final ZoneId UTC = TimeZone.getTimeZone("UTC").toZoneId();
    private static final Map<IndexStrategy, TemporalUnit> UNIT_MAP = new HashMap<IndexStrategy, TemporalUnit>();
    private String prefix;
    private IndexStrategy strategy;
    private TemporalUnit unit;
    private long expandTimeRangeInMs;

    public IndexSelector(String prefix, IndexStrategy strategy, long expandTimeRangeInMs) {
        this.prefix = prefix;
        this.strategy = strategy;
        this.unit = UNIT_MAP.get((Object)strategy);
        if (this.unit == null) {
            throw new UnsupportedOperationException("This is a programming mistake, please check the mapping for strategy=" + strategy.name());
        }
        this.expandTimeRangeInMs = expandTimeRangeInMs;
    }

    public List<String> getIndexNames(long start, long end) {
        Instant startDate;
        ArrayList<String> all = new ArrayList<String>();
        Instant endDate = this.adjustEndTime(new Date(end + this.expandTimeRangeInMs));
        Instant currentDate = startDate = Instant.ofEpochMilli(start - this.expandTimeRangeInMs);
        while (currentDate.isBefore(endDate)) {
            String index = this.strategy.getIndex(this.prefix, currentDate);
            all.add(index);
            currentDate = this.plusOne(currentDate);
        }
        String elementAfterSequence = this.strategy.getIndex(this.prefix, currentDate);
        String elementBeforeSequence = this.strategy.getIndex(this.prefix, this.minusOne(startDate));
        return this.collapseList(all, elementBeforeSequence, elementAfterSequence, 0);
    }

    private Instant minusOne(Instant date) {
        LocalDateTime current = LocalDateTime.ofInstant(date, UTC).minus(1L, this.unit).withMinute(0).withSecond(0);
        return current.atZone(UTC).toInstant();
    }

    private Instant plusOne(Instant date) {
        LocalDateTime current = LocalDateTime.ofInstant(date, UTC).plus(1L, this.unit).withMinute(0).withSecond(0);
        return current.atZone(UTC).toInstant();
    }

    private List<String> collapseList(List<String> orgList, String elementBeforeSequence, String elementAfterSequence, int offset) {
        if (orgList.size() < 2) {
            return orgList;
        }
        int collapseAfter = this.prefix.length() + this.strategy.getPattern().length() - 1 + offset;
        boolean beginningIsSameAsEnd = orgList.get(0).substring(0, collapseAfter).equals(orgList.get(orgList.size() - 1).substring(0, collapseAfter));
        boolean doCollapsingAtBeginning = !elementBeforeSequence.startsWith(orgList.get(0).substring(0, collapseAfter));
        boolean doCollapsingAtEnd = !elementAfterSequence.startsWith(orgList.get(orgList.size() - 1).substring(0, collapseAfter));
        doCollapsingAtBeginning = doCollapsingAtBeginning && doCollapsingAtEnd || doCollapsingAtBeginning && !beginningIsSameAsEnd;
        return this.collapseList(orgList, doCollapsingAtBeginning, doCollapsingAtEnd, 0);
    }

    private List<String> collapseList(List<String> orgList, boolean doCollapsingAtBeginning, boolean doCollapsingAtEnd, int offset) {
        if (orgList.size() < 2) {
            return orgList;
        }
        List<String> collapsedList = orgList;
        int collapseAfter = this.prefix.length() + this.strategy.getPattern().length() - 1 + offset;
        collapsedList = StringCollapser.forList(collapsedList).collapseAfterChars(collapseAfter).replaceCollapsedCharsWith("*").doCollapsingAtBeginning(doCollapsingAtBeginning).doCollapsingAtEnd(doCollapsingAtEnd).collapse();
        if (collapseAfter > this.prefix.length() + IndexStrategy.YEARLY.getPattern().length()) {
            collapsedList = this.collapseList(collapsedList, false, false, offset - 3);
        }
        return collapsedList;
    }

    private Instant adjustEndTime(Date date) {
        LocalDateTime current = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), UTC).withMinute(59).withSecond(59).withNano(999999999);
        if (this.strategy == IndexStrategy.YEARLY) {
            current = current.withMonth(12);
        }
        if (this.strategy == IndexStrategy.MONTHLY || this.strategy == IndexStrategy.YEARLY) {
            current = current.with(TemporalAdjusters.lastDayOfMonth());
        }
        if (this.strategy == IndexStrategy.DAILY || this.strategy == IndexStrategy.MONTHLY || this.strategy == IndexStrategy.YEARLY) {
            current = current.withHour(23);
        }
        return current.atZone(UTC).toInstant();
    }

    static {
        UNIT_MAP.put(IndexStrategy.YEARLY, ChronoUnit.YEARS);
        UNIT_MAP.put(IndexStrategy.MONTHLY, ChronoUnit.MONTHS);
        UNIT_MAP.put(IndexStrategy.DAILY, ChronoUnit.DAYS);
        UNIT_MAP.put(IndexStrategy.HOURLY, ChronoUnit.HOURS);
    }
}

