/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.template;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import org.opennms.plugins.elasticsearch.rest.template.TemplateLoader;
import org.opennms.plugins.elasticsearch.rest.template.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTemplateLoader
implements TemplateLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTemplateLoader.class);

    @Override
    public String load(Version serverVersion, String resource) throws IOException {
        for (int i = serverVersion.getMajor(); i >= 0; --i) {
            String versionSuffix = i == 0 ? "" : String.format(".es%d", i);
            String resourceWithSuffix = String.format("%s%s.json", resource, versionSuffix);
            String template = this.getResource(resourceWithSuffix);
            if (template != null) {
                LOG.info("Using template with resource name: {}", (Object)resource);
                return template;
            }
            LOG.debug("No template found with resource name: {}", (Object)resource);
        }
        throw new NullPointerException(String.format("No template found for server version %s and resource %s.", serverVersion, resource));
    }

    protected String getResource(String resource) throws IOException {
        try (InputStream inputStream = this.getResourceAsStream(resource);){
            if (inputStream == null) {
                String string = null;
                return string;
            }
            byte[] bytes = new byte[inputStream.available()];
            ByteStreams.readFully((InputStream)inputStream, (byte[])bytes);
            String string = new String(bytes);
            return string;
        }
    }

    protected InputStream getResourceAsStream(String resource) throws IOException {
        return this.getClass().getResourceAsStream(resource);
    }
}

