/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.index;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.TimeZone;

public enum IndexStrategy {
    YEARLY("yyyy"),
    MONTHLY("yyyy-MM"),
    DAILY("yyyy-MM-dd"),
    HOURLY("yyyy-MM-dd-HH");

    private final DateTimeFormatter dateFormat;
    private final String pattern;

    private IndexStrategy(String pattern) {
        this.pattern = pattern;
        ZoneId UTC = TimeZone.getTimeZone("UTC").toZoneId();
        this.dateFormat = DateTimeFormatter.ofPattern(pattern).withZone(UTC);
    }

    public String getIndex(String indexPrefix, TemporalAccessor temporal) {
        return String.format("%s-%s", indexPrefix, this.dateFormat.format(temporal));
    }

    public String getPattern() {
        return this.pattern;
    }
}

