/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.credentials;

import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.opennms.plugins.elasticsearch.rest.credentials.CredentialsScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialsParser {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialsParser.class);

    public Map<AuthScope, Credentials> parse(List<CredentialsScope> credentialsScopes) {
        HashMap<AuthScope, Credentials> credentialsMap = new HashMap<AuthScope, Credentials>();
        if (credentialsScopes != null) {
            for (CredentialsScope scope : credentialsScopes) {
                if (Strings.isNullOrEmpty((String)scope.getUsername()) || Strings.isNullOrEmpty((String)scope.getPassword())) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = scope.getUsername();
                    objectArray[1] = scope.getPassword() != null ? (scope.getPassword().isEmpty() ? "" : "******") : null;
                    objectArray[2] = scope.getUrl();
                    LOG.warn("Found incomplete credentials (username={}, password={}) for host {}. Username or password is empty/null. Ignoring.", objectArray);
                    continue;
                }
                if (Strings.isNullOrEmpty((String)scope.getUrl())) {
                    LOG.warn("No url specified. Ignoring.");
                    continue;
                }
                String urlString = CredentialsParser.fixUrl(scope.getUrl());
                try {
                    URL url = new URL(urlString);
                    HttpHost httpHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
                    credentialsMap.put(new AuthScope(httpHost), (Credentials)new UsernamePasswordCredentials(scope.getUsername(), scope.getPassword()));
                }
                catch (MalformedURLException ex) {
                    LOG.error("Defined url is invalid: {}", (Object)ex.getMessage());
                }
            }
        }
        return credentialsMap;
    }

    private static String fixUrl(String input) {
        if (!input.startsWith("http://") && !input.startsWith("https://")) {
            return "http://" + input;
        }
        return input;
    }
}

