/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graphml.rest.internal;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.graphdrawing.graphml.GraphmlType;
import org.opennms.features.graphml.model.GraphML;
import org.opennms.features.graphml.model.GraphMLReader;
import org.opennms.features.graphml.model.InvalidGraphException;
import org.opennms.features.graphml.service.GraphmlRepository;
import org.opennms.netmgt.graphml.rest.GraphmlRestService;

public class GraphmlRestServiceImpl
implements GraphmlRestService {
    private final GraphmlRepository graphmlRepository;

    public GraphmlRestServiceImpl(GraphmlRepository graphmlRepository) {
        this.graphmlRepository = Objects.requireNonNull(graphmlRepository);
    }

    @Override
    public Response createGraph(String graphname, GraphmlType graphmlType) throws IOException {
        if (this.graphmlRepository.exists(graphname)) {
            return Response.status((int)500).entity((Object)("Graph with name " + graphname + " already exists")).build();
        }
        try {
            GraphML convertedGraphML = GraphMLReader.convert((GraphmlType)graphmlType);
            String label = (String)convertedGraphML.getProperty("label", (Object)graphname);
            this.graphmlRepository.save(graphname, label, graphmlType);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (InvalidGraphException ex) {
            return Response.status((int)500).entity((Object)ex.getMessage()).build();
        }
    }

    @Override
    public Response deleteGraph(String graphname) throws IOException {
        if (!this.graphmlRepository.exists(graphname)) {
            throw new NoSuchElementException("No GraphML file found with name  " + graphname);
        }
        this.graphmlRepository.delete(graphname);
        return Response.ok().build();
    }

    @Override
    public Response getGraph(String graphname) throws IOException {
        GraphmlType byName = this.graphmlRepository.findByName(graphname);
        return Response.ok((Object)byName).build();
    }
}

