/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.topology;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.support.breadcrumbs.BreadcrumbStrategy;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.MetaTopologyProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.graph.api.service.GraphService;
import org.opennms.netmgt.graph.provider.topology.LegacyTopologyConfiguration;
import org.opennms.netmgt.graph.provider.topology.LegacyTopologyProvider;

public class LegacyMetaTopologyProvider
implements MetaTopologyProvider {
    private final GraphService graphService;
    private final String containerId;
    private final Map<String, GraphProvider> providers;

    public LegacyMetaTopologyProvider(LegacyTopologyConfiguration configuration, NodeDao nodeDao, GraphService graphService, String containerId) {
        this.graphService = Objects.requireNonNull(graphService);
        this.containerId = Objects.requireNonNull(containerId);
        this.providers = graphService.getGraphContainerInfo(containerId).getNamespaces().stream().map(namespace -> new LegacyTopologyProvider(configuration, nodeDao, graphService, containerId, (String)namespace)).collect(Collectors.toMap(LegacyTopologyProvider::getNamespace, Function.identity()));
    }

    public GraphProvider getDefaultGraphProvider() {
        String defaultNamespace = this.graphService.getGraphContainerInfo(this.containerId).getPrimaryGraphInfo().getNamespace();
        return this.providers.get(defaultNamespace);
    }

    public Collection<GraphProvider> getGraphProviders() {
        return this.providers.values();
    }

    public Collection<VertexRef> getOppositeVertices(VertexRef vertexRef) {
        Objects.requireNonNull(vertexRef);
        GraphProvider graphProvider = this.providers.get(vertexRef.getNamespace());
        if (graphProvider.getCurrentGraph() != null) {
            EdgeRef[] referencingEdges = graphProvider.getCurrentGraph().getEdgeIdsForVertex(vertexRef);
            List<VertexRef> oppositeVertices = graphProvider.getCurrentGraph().getEdges(Arrays.asList(referencingEdges)).stream().filter(edge -> !edge.getSource().getVertex().getNamespace().equals(vertexRef.getNamespace()) || !edge.getTarget().getVertex().getNamespace().equals(vertexRef.getNamespace())).map(edge -> edge.getSource().getVertex().getNamespace().equals(vertexRef.getNamespace()) ? edge.getTarget().getVertex() : edge.getSource().getVertex()).collect(Collectors.toList());
            return oppositeVertices;
        }
        return Collections.EMPTY_LIST;
    }

    public GraphProvider getGraphProviderBy(String namespace) {
        return this.providers.get(namespace);
    }

    public BreadcrumbStrategy getBreadcrumbStrategy() {
        return BreadcrumbStrategy.NONE;
    }

    public String getId() {
        return this.containerId;
    }
}

