/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.persistence;

import java.util.Objects;
import org.opennms.netmgt.graph.api.ImmutableGraphContainer;
import org.opennms.netmgt.graph.api.generic.GenericGraphContainer;
import org.opennms.netmgt.graph.api.info.DefaultGraphContainerInfo;
import org.opennms.netmgt.graph.api.info.DefaultGraphInfo;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.api.persistence.GraphRepository;
import org.opennms.netmgt.graph.api.service.GraphContainerProvider;
import org.opennms.netmgt.graph.provider.persistence.CustomGraphContainer;
import org.opennms.netmgt.graph.provider.persistence.CustomVertex;

public class PersistenceGraphContainerProvider
implements GraphContainerProvider {
    private static final String CONTAINER_ID = "persistence-example";
    private final GraphRepository graphRepository;

    public PersistenceGraphContainerProvider(GraphRepository graphRepository) {
        this.graphRepository = Objects.requireNonNull(graphRepository);
    }

    public ImmutableGraphContainer loadGraphContainer() {
        GenericGraphContainer genericGraphContainer = this.graphRepository.findContainerById(CONTAINER_ID);
        return new CustomGraphContainer(genericGraphContainer);
    }

    public GraphContainerInfo getContainerInfo() {
        GraphContainerInfo containerInfoById = this.graphRepository.findContainerInfoById(CONTAINER_ID);
        DefaultGraphContainerInfo defaultGraphContainerInfo = new DefaultGraphContainerInfo(containerInfoById.getId());
        defaultGraphContainerInfo.setDescription(containerInfoById.getDescription());
        defaultGraphContainerInfo.setLabel(containerInfoById.getLabel());
        containerInfoById.getGraphInfos().forEach(gi -> {
            DefaultGraphInfo defaultGraphInfo = new DefaultGraphInfo(gi, CustomVertex.class);
            defaultGraphContainerInfo.addGraphInfo((GraphInfo)defaultGraphInfo);
        });
        return defaultGraphContainerInfo;
    }

    public void init() {
        if (this.graphRepository.findContainerInfoById(CONTAINER_ID) != null) {
            this.graphRepository.deleteContainer(CONTAINER_ID);
        }
        this.graphRepository.save(PersistenceGraphContainerProvider.createContainerInfo());
    }

    protected static GraphContainerInfo createContainerInfo() {
        DefaultGraphContainerInfo info = new DefaultGraphContainerInfo(CONTAINER_ID);
        info.setDescription("Example container which uses the GraphRepository for persistence");
        info.setLabel("Example Persistence Graph Container");
        DefaultGraphInfo graphInfo = new DefaultGraphInfo("persistence-example.graph", CustomVertex.class);
        graphInfo.setDescription("The only graph of the container");
        graphInfo.setLabel("Graph");
        info.getGraphInfos().add(graphInfo);
        return info;
    }
}

