/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.graphml;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opennms.features.graphml.model.GraphML;
import org.opennms.features.graphml.model.GraphMLGraph;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericGraphContainer;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphmlToGraphConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GraphmlToGraphConverter.class);
    private static final String FOCUS_STRATEGY = "focus-strategy";
    private static final String FOCUS_IDS = "focus-ids";
    private HashMap<String, GraphMLGraph> vertexIdToGraphMapping = new HashMap();

    public GenericGraphContainer convert(GraphML graphML) {
        graphML.getGraphs().stream().forEach(g -> g.getNodes().stream().forEach(n -> {
            if (this.vertexIdToGraphMapping.containsKey(n.getId())) {
                throw new IllegalStateException("GraphML graph contains vertices with same id. Bailing");
            }
            this.vertexIdToGraphMapping.put(n.getId(), (GraphMLGraph)g);
        }));
        String graphContainerId = GraphmlToGraphConverter.determineGraphContainerId(graphML);
        GenericGraphContainer.GenericGraphContainerBuilder graphContainerBuilder = GenericGraphContainer.builder().id(graphContainerId).label((String)graphML.getProperty("label")).description((String)graphML.getProperty("description"));
        for (GraphMLGraph eachGraph : graphML.getGraphs()) {
            GenericGraph convertedGraph = this.convert(eachGraph);
            graphContainerBuilder.addGraph(convertedGraph);
        }
        this.vertexIdToGraphMapping.clear();
        GenericGraphContainer graphContainer = graphContainerBuilder.build();
        return graphContainer;
    }

    private final GenericGraph convert(GraphMLGraph graphMLGraph) {
        GenericGraph.GenericGraphBuilder graphBuilder = GenericGraph.builder().property("enrichment.resolveNodes", (Object)true).properties((Map)graphMLGraph.getProperties());
        List vertices = graphMLGraph.getNodes().stream().map(n -> ((GenericVertex.GenericVertexBuilder)((GenericVertex.GenericVertexBuilder)GenericVertex.builder().namespace(graphBuilder.getNamespace())).id(n.getId()).properties((Map)n.getProperties())).build()).collect(Collectors.toList());
        graphBuilder.addVertices(vertices);
        List edges = graphMLGraph.getEdges().stream().map(e -> {
            String sourceNamespace = (String)this.vertexIdToGraphMapping.get(e.getSource().getId()).getProperty("namespace");
            String targetNamespace = (String)this.vertexIdToGraphMapping.get(e.getTarget().getId()).getProperty("namespace");
            GenericVertex source = ((GenericVertex.GenericVertexBuilder)GenericVertex.builder().namespace(sourceNamespace)).id(e.getSource().getId()).build();
            GenericVertex target = ((GenericVertex.GenericVertexBuilder)GenericVertex.builder().namespace(targetNamespace)).id(e.getTarget().getId()).build();
            GenericEdge edge = ((GenericEdge.GenericEdgeBuilder)((GenericEdge.GenericEdgeBuilder)GenericEdge.builder().namespace(graphBuilder.getNamespace())).source(source.getVertexRef()).target(target.getVertexRef()).properties((Map)e.getProperties())).build();
            return edge;
        }).collect(Collectors.toList());
        graphBuilder.addEdges(edges);
        GraphmlToGraphConverter.applyFocus(graphMLGraph, graphBuilder);
        return graphBuilder.build();
    }

    private static void applyFocus(GraphMLGraph graphMLGraph, GenericGraph.GenericGraphBuilder graphBuilder) {
        String strategy = (String)graphMLGraph.getProperty(FOCUS_STRATEGY);
        if (strategy == null || "empty".equalsIgnoreCase(strategy)) {
            graphBuilder.focus().empty().apply();
        } else if ("all".equalsIgnoreCase(strategy)) {
            graphBuilder.focus().all().apply();
        } else if ("first".equalsIgnoreCase(strategy)) {
            graphBuilder.focus().first().apply();
        } else if ("specific".equalsIgnoreCase(strategy) || "selection".equalsIgnoreCase(strategy)) {
            List<String> focusIds = GraphmlToGraphConverter.getFocusIds(graphMLGraph);
            graphBuilder.focus().selection(graphBuilder.getNamespace(), focusIds).apply();
        } else {
            Object[] supportedStrategies = new String[]{"empty", "all", "first", "specific"};
            throw new IllegalStateException("Provided focus strategy '" + strategy + "' is not supported. Supported values are: " + Arrays.toString(supportedStrategies));
        }
    }

    private static List<String> getFocusIds(GraphMLGraph inputGraph) {
        String property = (String)inputGraph.getProperty(FOCUS_IDS);
        if (property != null) {
            Object[] split = property.split(",");
            return Lists.newArrayList((Object[])split);
        }
        return Lists.newArrayList();
    }

    protected static String determineGraphContainerId(GraphML graphML) {
        if (graphML.getProperty("containerId") != null) {
            return (String)graphML.getProperty("containerId");
        }
        LOG.warn("No property 'containerId' was provided. Calculating the container id using the graph's ids");
        String calculatedId = graphML.getGraphs().stream().map(g -> g.getId()).collect(Collectors.joining("."));
        return calculatedId;
    }
}

