/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.bsm;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.graph.GraphEdge;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.graph.api.ImmutableGraph;
import org.opennms.netmgt.graph.api.VertexRef;
import org.opennms.netmgt.graph.api.info.DefaultGraphInfo;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.api.service.GraphContainerCache;
import org.opennms.netmgt.graph.api.service.GraphProvider;
import org.opennms.netmgt.graph.provider.bsm.BusinessServiceEdge;
import org.opennms.netmgt.graph.provider.bsm.BusinessServiceGraph;
import org.opennms.netmgt.graph.provider.bsm.BusinessServiceVertex;
import org.opennms.netmgt.model.events.EventUtils;

public class BusinessServiceGraphProvider
implements GraphProvider,
EventListener {
    private static final List<String> UEI_LIST = Lists.newArrayList((Object[])new String[]{"uei.opennms.org/internal/reloadDaemonConfigSuccessful"});
    private final EventIpcManager eventIpcManager;
    private final BusinessServiceManager businessServiceManager;
    private final GraphContainerCache graphContainerCache;

    public BusinessServiceGraphProvider(GraphContainerCache graphContainerCache, BusinessServiceManager businessServiceManager, EventIpcManager eventIpcManager) {
        this.businessServiceManager = Objects.requireNonNull(businessServiceManager);
        this.eventIpcManager = Objects.requireNonNull(eventIpcManager);
        this.graphContainerCache = Objects.requireNonNull(graphContainerCache);
    }

    public ImmutableGraph<?, ?> loadGraph() {
        BusinessServiceGraph.BusinessServiceGraphBuilder bsmGraph = (BusinessServiceGraph.BusinessServiceGraphBuilder)BusinessServiceGraph.builder().graphInfo(this.getGraphInfo());
        org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph sourceGraph = this.businessServiceManager.getGraph();
        for (GraphVertex topLevelBusinessService : sourceGraph.getVerticesByLevel(0)) {
            BusinessServiceGraphProvider.addVertex(bsmGraph, sourceGraph, topLevelBusinessService, null);
        }
        VertexRef defaultFocusVertex = this.getDefaultFocusVertex(bsmGraph);
        if (defaultFocusVertex != null) {
            bsmGraph.focus().selection(defaultFocusVertex).apply();
        } else {
            bsmGraph.focus().selection((List)Lists.newArrayList()).apply();
        }
        return bsmGraph.build();
    }

    public GraphInfo getGraphInfo() {
        DefaultGraphInfo graphInfo = new DefaultGraphInfo("bsm");
        graphInfo.setLabel("Business Service Graph");
        graphInfo.setDescription("Displays the hierarchy of the defined Business Services and their computed operational states.");
        return graphInfo;
    }

    private VertexRef getDefaultFocusVertex(BusinessServiceGraph.BusinessServiceGraphBuilder graphBuilder) {
        List businessServices = this.businessServiceManager.findMatching(new CriteriaBuilder(BusinessService.class).orderBy("id", true).limit(Integer.valueOf(1)).toCriteria());
        if (!businessServices.isEmpty()) {
            BusinessService businessService = (BusinessService)businessServices.iterator().next();
            String vertexId = (Object)((Object)BusinessServiceVertex.Type.BusinessService) + ":" + businessService.getId();
            VertexRef vertexRef = graphBuilder.getVertexRef(vertexId);
            return vertexRef;
        }
        return null;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void onEvent(IEvent e) {
        String daemonName;
        if (e.getUei().equals("uei.opennms.org/internal/reloadDaemonConfigSuccessful") && (daemonName = EventUtils.getParm((IEvent)e, (String)"daemonName")) != null && "bsmd".equalsIgnoreCase(daemonName)) {
            this.graphContainerCache.invalidate("bsm");
        }
    }

    public void init() {
        this.eventIpcManager.addEventListener((EventListener)this, UEI_LIST);
    }

    public void destroy() {
        this.eventIpcManager.removeEventListener((EventListener)this, UEI_LIST);
    }

    private static void addVertex(BusinessServiceGraph.BusinessServiceGraphBuilder targetGraphBuilder, org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph sourceGraph, GraphVertex graphVertex, BusinessServiceVertex topologyVertex) {
        if (topologyVertex == null) {
            topologyVertex = BusinessServiceVertex.builder().graphVertex(graphVertex).build();
            targetGraphBuilder.addVertex(topologyVertex);
        }
        for (GraphEdge graphEdge : sourceGraph.getOutEdges((Object)graphVertex)) {
            GraphVertex childVertex = (GraphVertex)sourceGraph.getOpposite((Object)graphVertex, (Object)graphEdge);
            BusinessServiceVertex.BusinessServiceVertexBuilder childTopologyVertexBuilder = BusinessServiceVertex.builder().graphVertex(childVertex);
            sourceGraph.getInEdges((Object)childVertex).stream().map(GraphEdge::getFriendlyName).filter(s -> !Strings.isNullOrEmpty((String)s)).findFirst().ifPresent(arg_0 -> ((BusinessServiceVertex.BusinessServiceVertexBuilder)childTopologyVertexBuilder).label(arg_0));
            BusinessServiceVertex childTopologyVertex = childTopologyVertexBuilder.build();
            targetGraphBuilder.addVertex(childTopologyVertex);
            BusinessServiceEdge edge = ((BusinessServiceEdge.BusinessServiceEdgeBuilder)((BusinessServiceEdge.BusinessServiceEdgeBuilder)BusinessServiceEdge.builder().graphEdge(graphEdge).source(topologyVertex.getVertexRef())).target(childTopologyVertex.getVertexRef())).build();
            targetGraphBuilder.addEdge(edge);
            BusinessServiceGraphProvider.addVertex(targetGraphBuilder, sourceGraph, childVertex, childTopologyVertex);
        }
    }
}

