/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.application;

import java.util.Objects;
import org.opennms.netmgt.graph.api.VertexRef;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.domain.AbstractDomainVertex;
import org.opennms.netmgt.graph.provider.application.ApplicationVertexType;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsMonitoredService;

public final class ApplicationVertex
extends AbstractDomainVertex {
    public ApplicationVertex(GenericVertex vertex) {
        super(vertex);
        Objects.requireNonNull(this.getProperty("vertexType"), "vertexType cannot be null");
        if (ApplicationVertexType.Service == this.getVertexType()) {
            Objects.requireNonNull(this.getProperty("serviceTypeId"), "serviceTypeId cannot be null");
        }
        if (ApplicationVertexType.Application == this.getVertexType()) {
            Objects.requireNonNull(this.getProperty("applicationId"), "applicationId cannot be null");
        }
    }

    public String getName() {
        return (String)this.delegate.getProperty("name");
    }

    public ApplicationVertexType getVertexType() {
        return (ApplicationVertexType)((Object)this.delegate.getProperty("vertexType"));
    }

    public String getIpAddress() {
        return (String)this.delegate.getProperty("ipAddress");
    }

    public VertexRef getVertexRef() {
        return this.delegate.getVertexRef();
    }

    public Integer getServiceTypeId() {
        return (Integer)this.getProperty("serviceTypeId");
    }

    public Integer getApplicationId() {
        return (Integer)this.getProperty("applicationId");
    }

    private <T> T getProperty(String key) {
        Objects.requireNonNull(key);
        return (T)this.delegate.getProperty(key);
    }

    static String createVertexId(OnmsApplication application) {
        Objects.requireNonNull(application);
        return (Object)((Object)ApplicationVertexType.Application) + ":" + application.getId();
    }

    static String createVertexId(OnmsMonitoredService service) {
        Objects.requireNonNull(service);
        return (Object)((Object)ApplicationVertexType.Service) + ":" + service.getId();
    }

    public static ApplicationVertexBuilder builder() {
        return new ApplicationVertexBuilder();
    }

    public static ApplicationVertex from(GenericVertex genericVertex) {
        return new ApplicationVertex(genericVertex);
    }

    public static final class ApplicationVertexBuilder
    extends AbstractDomainVertex.AbstractDomainVertexBuilder<ApplicationVertexBuilder> {
        private ApplicationVertexBuilder() {
        }

        public ApplicationVertexBuilder application(OnmsApplication application) {
            this.properties.put("id", ApplicationVertex.createVertexId(application));
            this.properties.put("vertexType", ApplicationVertexType.Application);
            this.properties.put("applicationId", application.getId());
            this.properties.put("name", application.getName());
            return this;
        }

        public ApplicationVertexBuilder service(OnmsMonitoredService monitoredService) {
            this.properties.put("id", ApplicationVertex.createVertexId(monitoredService));
            this.properties.put("vertexType", ApplicationVertexType.Service);
            this.properties.put("serviceTypeId", Objects.requireNonNull(monitoredService.getServiceType().getId()));
            this.properties.put("name", monitoredService.getServiceName());
            this.properties.put("ipAddress", monitoredService.getIpAddress().toString());
            super.nodeRef(Integer.toString(monitoredService.getNodeId()));
            return this;
        }

        public ApplicationVertexBuilder name(String name) {
            this.properties.put("name", name);
            this.label(name);
            return this;
        }

        public ApplicationVertex build() {
            this.namespace("application");
            return new ApplicationVertex(((GenericVertex.GenericVertexBuilder)GenericVertex.builder().properties(this.properties)).build());
        }
    }

    private static interface Property {
        public static final String VERTEX_TYPE = "vertexType";
        public static final String NAME = "name";
        public static final String IP_ADDRESS = "ipAddress";
        public static final String SERVICE_TYPE_ID = "serviceTypeId";
        public static final String APPLICATION_ID = "applicationId";
    }
}

