/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.application;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.MonitoredServiceStatusEntity;
import org.opennms.netmgt.graph.api.enrichment.EnrichmentGraphBuilder;
import org.opennms.netmgt.graph.api.enrichment.EnrichmentProcessor;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.api.info.StatusInfo;
import org.opennms.netmgt.graph.domain.AbstractDomainVertex;
import org.opennms.netmgt.graph.provider.application.ApplicationVertex;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsSeverity;

public class ApplicationStatusEnrichment
implements EnrichmentProcessor {
    private static final StatusInfo DEFAULT_STATUS = StatusInfo.defaultStatus().build();
    private final ApplicationDao applicationDao;

    public ApplicationStatusEnrichment(ApplicationDao applicationDao) {
        this.applicationDao = Objects.requireNonNull(applicationDao);
    }

    public boolean canEnrich(GenericGraph graph) {
        return graph.getNamespace().equals("application");
    }

    public void enrich(EnrichmentGraphBuilder graphBuilder) {
        List allVertices = graphBuilder.getView().getVertices();
        List rootVertices = graphBuilder.getView().getVertices().stream().map(ApplicationVertex::from).filter(v -> v.getApplicationId() != null).map(AbstractDomainVertex::asGenericVertex).collect(Collectors.toList());
        ArrayList childVertices = new ArrayList(allVertices);
        childVertices.removeAll(rootVertices);
        HashMap<Integer, StatusInfo> childStatusMap = new HashMap<Integer, StatusInfo>();
        HashMap vertexStatusMap = new HashMap();
        List applications = rootVertices.stream().map(v -> ApplicationVertex.from(v).getApplicationId()).map(id -> (OnmsApplication)this.applicationDao.get((Serializable)id)).collect(Collectors.toList());
        List result = this.applicationDao.getAlarmStatus(applications);
        for (MonitoredServiceStatusEntity eachRow : result) {
            StatusInfo statusInfo = StatusInfo.builder((OnmsSeverity)eachRow.getSeverity()).count(eachRow.getCount()).build();
            childStatusMap.put(eachRow.getNodeId(), statusInfo);
        }
        for (GenericVertex eachVertex : childVertices) {
            int nodeId = eachVertex.getNodeRef().getNodeId();
            childStatusMap.putIfAbsent(nodeId, DEFAULT_STATUS);
            vertexStatusMap.put(eachVertex, childStatusMap.get(nodeId));
        }
        for (GenericVertex eachRoot : rootVertices) {
            StatusInfo.StatusInfoBuilder rootStatusBuilder = StatusInfo.from((StatusInfo)DEFAULT_STATUS);
            for (GenericEdge eachEdge : graphBuilder.getView().getConnectingEdges(eachRoot)) {
                GenericVertex serviceVertex = graphBuilder.getView().resolveVertex(eachEdge.getTarget());
                StatusInfo childStatus = (StatusInfo)childStatusMap.get(serviceVertex.getNodeRef().getNodeId());
                if (rootStatusBuilder.getSeverity().isLessThan(childStatus.getSeverity())) {
                    rootStatusBuilder.severity(childStatus.getSeverity()).count(childStatus.getCount().longValue());
                    continue;
                }
                if (!rootStatusBuilder.getSeverity().isEqual(childStatus.getSeverity())) continue;
                rootStatusBuilder.count(rootStatusBuilder.getCount() + childStatus.getCount());
            }
            vertexStatusMap.put(eachRoot, rootStatusBuilder.build());
        }
        vertexStatusMap.entrySet().forEach(entry -> graphBuilder.property((GenericVertex)entry.getKey(), "status", entry.getValue()));
    }
}

