/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.shell;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.api.service.GraphContainerProvider;
import org.opennms.netmgt.graph.api.service.GraphService;

@Service
@Command(scope="opennms", name="graph-list", description="List all available graph containers and its graphs")
public class GraphListCommand
implements Action {
    private static final int MAX_DESCRIPTION_LENGTH = 100;
    private static final String CONTAINER_ROW_TEMPLATE = "%%-%ds   %%-%ds   %%-%ds   %%s";
    private static final String GRAPH_ROW_TEMPLATE = "%%-%ds   %%-%ds   %%-%ds   %%s";
    @Option(name="-a", aliases={"--all"}, description="Lists all graphs as well")
    public boolean showAll = false;
    @Reference
    private GraphService graphService;

    public Object execute() throws Exception {
        List graphContainerInfoList = this.graphService.getGraphContainerInfos();
        if (!graphContainerInfoList.isEmpty()) {
            int containerCount = graphContainerInfoList.size();
            int graphCount = graphContainerInfoList.stream().mapToInt(gi -> gi.getNamespaces().size()).sum();
            System.out.println(containerCount + " registered Graph Container(s):");
            int maxContainerIdLength = graphContainerInfoList.stream().mapToInt(ci -> ci.getId().length()).max().getAsInt();
            int maxContainerLabelLength = graphContainerInfoList.stream().mapToInt(ci -> ci.getLabel().length()).max().getAsInt();
            String ContainerRowFormat = String.format("%%-%ds   %%-%ds   %%-%ds   %%s", maxContainerIdLength > "Container ID".length() ? maxContainerIdLength : "Container ID".length(), maxContainerLabelLength, 100);
            System.out.println(String.format(ContainerRowFormat, "Container ID", "Label", "Description", "Graph Namespaces"));
            for (GraphContainerInfo eachContainerInfo : graphContainerInfoList) {
                String description = GraphListCommand.cutString(eachContainerInfo.getDescription());
                System.out.println(String.format(ContainerRowFormat, eachContainerInfo.getId(), eachContainerInfo.getLabel() == null ? "" : eachContainerInfo.getLabel(), description, eachContainerInfo.getNamespaces()));
            }
            if (this.showAll) {
                System.out.println();
                System.out.println(graphCount + " registered Graph(s):");
                List graphInfos = graphContainerInfoList.stream().flatMap(ci -> ci.getGraphInfos().stream()).collect(Collectors.toList());
                int maxNamespaceLength = graphInfos.stream().mapToInt(gi -> gi.getNamespace().length()).max().getAsInt();
                int maxGraphLabelLength = graphInfos.stream().mapToInt(gi -> gi.getLabel() != null ? gi.getLabel().length() : 0).max().getAsInt();
                String GraphRowFormat = String.format("%%-%ds   %%-%ds   %%-%ds   %%s", maxNamespaceLength > "Namespace".length() ? maxNamespaceLength : "Namespace".length(), maxGraphLabelLength, 100);
                System.out.println(String.format(GraphRowFormat, "Namespace", "Label", "Description", "Container ID"));
                for (GraphContainerInfo eachContainerInfo : graphContainerInfoList) {
                    for (GraphInfo eachGraphInfo : eachContainerInfo.getGraphInfos()) {
                        String description = GraphListCommand.cutString(eachGraphInfo.getDescription());
                        System.out.println(String.format(GraphRowFormat, eachGraphInfo.getNamespace(), eachGraphInfo.getLabel() == null ? "" : eachGraphInfo.getLabel(), description, eachContainerInfo.getId()));
                    }
                }
            }
        } else {
            System.out.println("No " + GraphContainerProvider.class.getSimpleName() + " registered");
        }
        return null;
    }

    private static String cutString(String input) {
        if (input != null && input.length() > 100) {
            return input.substring(0, 97) + "...";
        }
        if (input == null) {
            return "";
        }
        return input;
    }
}

