/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.shell;

import com.google.common.base.Strings;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.graph.api.ImmutableGraph;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.renderer.GraphRenderer;
import org.opennms.netmgt.graph.api.service.GraphService;
import org.opennms.netmgt.graph.shell.completer.ContainerIdCompleter;
import org.opennms.netmgt.graph.shell.completer.ContainerNamespaceCompleter;

@Service
@Command(scope="opennms", name="graph-get", description="Gets a graph identified by its namespace")
public class GraphGetCommand
implements Action {
    @Reference
    private GraphService graphService;
    @Reference
    private GraphRenderer graphRenderer;
    @Completion(value=ContainerIdCompleter.class)
    @Option(name="--container", description="The id of the container", required=false)
    private String containerId;
    @Completion(value=ContainerNamespaceCompleter.class)
    @Option(name="--namespace", description="The namespace of the graph", required=true)
    private String namespace;

    public Object execute() throws Exception {
        GenericGraph genericGraph = this.getGraph();
        if (genericGraph == null) {
            System.out.println("No graph in container with id '" + this.containerId + "' and namespace '" + this.namespace + "' found");
        } else {
            String rendered = this.graphRenderer.render(2, (ImmutableGraph)genericGraph);
            System.out.println(rendered);
        }
        return null;
    }

    private GenericGraph getGraph() {
        if (!Strings.isNullOrEmpty((String)this.containerId)) {
            return this.graphService.getGraph(this.containerId, this.namespace);
        }
        return this.graphService.getGraph(this.namespace);
    }
}

