/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.shell;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.service.GraphContainerCache;
import org.opennms.netmgt.graph.api.service.GraphService;
import org.opennms.netmgt.graph.shell.completer.ContainerIdCompleter;

@Service
@Command(scope="opennms-graph", name="force-reload", description="Invalidates the cache for the given container, forcing it to reload when next request occurs")
public class GraphReloadCommand
implements Action {
    @Reference
    private GraphContainerCache graphContainerCache;
    @Reference
    private GraphService graphService;
    @Completion(value=ContainerIdCompleter.class)
    @Option(name="--container", description="The id of the container", required=true)
    private String containerId;

    public Object execute() throws Exception {
        GraphContainerInfo graphContainerInfo = this.graphService.getGraphContainerInfo(this.containerId);
        if (graphContainerInfo == null) {
            System.out.println("No graph in container with id '" + this.containerId + "' found");
        } else {
            this.graphContainerCache.invalidate(this.containerId);
            System.out.println("Container invalidated. On next request, the container is reloaded");
        }
        return null;
    }
}

