/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.service;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import org.opennms.netmgt.graph.api.info.DefaultGraphContainerInfo;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.api.service.GraphContainerProvider;
import org.opennms.netmgt.graph.api.service.GraphProvider;
import org.opennms.netmgt.graph.service.SingleGraphContainerProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class GraphProviderManager {
    private static final String LABEL_KEY = "label";
    private static final String DESCRIPTION_KEY = "description";
    private static final String CONTAINER_ID_KEY = "containerId";
    private final BundleContext bundleContext;
    private final Map<GraphProvider, ServiceRegistration<GraphContainerProvider>> graphProviderServices = new HashMap<GraphProvider, ServiceRegistration<GraphContainerProvider>>();

    public GraphProviderManager(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    public void onBind(GraphProvider graphProvider, Map<String, String> properties) {
        GraphInfo graphInfo = graphProvider.getGraphInfo();
        String label = properties.getOrDefault(LABEL_KEY, graphInfo.getLabel());
        String description = properties.getOrDefault(DESCRIPTION_KEY, graphInfo.getDescription());
        String containerId = properties.getOrDefault(CONTAINER_ID_KEY, graphInfo.getNamespace());
        DefaultGraphContainerInfo containerInfo = new DefaultGraphContainerInfo(containerId);
        containerInfo.setDescription(description);
        containerInfo.setLabel(label);
        Map<String, String> actualProperties = GraphProviderManager.getActualProperties(properties);
        SingleGraphContainerProvider singleGraphContainerProvider = new SingleGraphContainerProvider(graphProvider, (GraphContainerInfo)containerInfo);
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(GraphContainerProvider.class, (Object)singleGraphContainerProvider, new Hashtable<String, String>(actualProperties));
        this.graphProviderServices.put(graphProvider, (ServiceRegistration<GraphContainerProvider>)serviceRegistration);
    }

    public void onUnbind(GraphProvider graphProvider, Map<String, String> properties) {
        ServiceRegistration<GraphContainerProvider> removedService = this.graphProviderServices.remove(graphProvider);
        if (removedService != null) {
            removedService.unregister();
        }
    }

    public static Map<String, String> getActualProperties(Map<String, String> properties) {
        HashMap<String, String> actualProperties = new HashMap<String, String>();
        properties.keySet().stream().filter(key -> !key.startsWith("service") && !key.startsWith("osgi") && !key.equals("objectClass")).forEach(key -> {
            String cfr_ignored_0 = (String)actualProperties.put((String)key, (String)properties.get(key));
        });
        return actualProperties;
    }
}

