/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.persistence.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.opennms.netmgt.graph.persistence.converter.CollectionConverter;
import org.opennms.netmgt.graph.persistence.converter.Converter;
import org.opennms.netmgt.graph.persistence.converter.EnumConverter;
import org.opennms.netmgt.graph.persistence.converter.PrimitiveConverter;

public class ConverterService {
    private final List<Converter<?>> converterRegistry = new ArrayList();

    public ConverterService() {
        this.converterRegistry.add(new PrimitiveConverter<Boolean>(Boolean.class, Boolean::valueOf));
        this.converterRegistry.add(new PrimitiveConverter<Float>(Float.class, Float::valueOf));
        this.converterRegistry.add(new PrimitiveConverter<Integer>(Integer.class, Integer::valueOf));
        this.converterRegistry.add(new PrimitiveConverter<Double>(Double.class, Double::valueOf));
        this.converterRegistry.add(new PrimitiveConverter<String>(String.class, string -> string));
        this.converterRegistry.add(new PrimitiveConverter<Short>(Short.class, Short::valueOf));
        this.converterRegistry.add(new PrimitiveConverter<Byte>(Byte.class, Byte::valueOf));
        this.converterRegistry.add(new EnumConverter());
        this.converterRegistry.add(new CollectionConverter(this));
    }

    public <T> Object toValue(Class<T> type, String stringRepresentation) {
        Converter converter = this.getConverter(type);
        return converter.toValue(type, stringRepresentation);
    }

    public <T> String toStringRepresentation(Class<?> type, T object) throws IllegalStateException {
        Converter converter = this.getConverter(type);
        return converter.toStringRepresentation(object);
    }

    private Converter getConverter(Class<?> clazz) throws IllegalStateException {
        Optional<Converter> converter = this.converterRegistry.stream().filter(con -> con.canConvert(clazz)).findFirst();
        if (!converter.isPresent()) {
            throw new IllegalStateException("Missing converter for class '" + clazz + "'");
        }
        return converter.get();
    }
}

