/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.persistence.converter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.netmgt.graph.persistence.converter.Converter;
import org.opennms.netmgt.graph.persistence.converter.ConverterService;
import org.opennms.netmgt.graph.persistence.converter.collection.SerializedCollection;
import org.opennms.netmgt.graph.persistence.converter.collection.SerializedCollectionEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionConverter
implements Converter<Collection<?>> {
    private Logger LOG = LoggerFactory.getLogger(CollectionConverter.class);
    private ConverterService converterService;
    private Gson gson = new GsonBuilder().registerTypeAdapter(Class.class, (Object)new ClassAdapter()).create();

    CollectionConverter(ConverterService converterService) {
        this.converterService = converterService;
    }

    @Override
    public String toStringRepresentation(Collection<?> collection) {
        List<SerializedCollectionEntry> persistedEntries = collection.stream().map(entry -> new SerializedCollectionEntry(entry.getClass(), this.converterService.toStringRepresentation(entry.getClass(), entry))).collect(Collectors.toList());
        SerializedCollection serializedCollection = new SerializedCollection();
        serializedCollection.setType(collection.getClass());
        serializedCollection.setEntries(persistedEntries);
        return this.gson.toJson((Object)serializedCollection);
    }

    @Override
    public Collection<?> toValue(Class<Collection<?>> type, String string) {
        SerializedCollection serializedCollection = (SerializedCollection)this.gson.fromJson(string, SerializedCollection.class);
        ArrayList values = new ArrayList();
        serializedCollection.getEntries().stream().map(entry -> this.converterService.toValue(entry.getType(), entry.getValue())).forEach(values::add);
        Collection<?> resurrectedCollection = this.recreateCollection(serializedCollection.getType(), values);
        return resurrectedCollection;
    }

    @Override
    public boolean canConvert(Class<?> type) {
        return Collection.class.isAssignableFrom(type);
    }

    private Collection<?> recreateCollection(Class<Collection<?>> type, List values) {
        if (ImmutableList.class.isAssignableFrom(type)) {
            return ImmutableList.copyOf((Collection)values);
        }
        if (ImmutableSet.class.isAssignableFrom(type)) {
            return ImmutableSet.copyOf((Collection)values);
        }
        this.LOG.warn("Cannot recreate {}, will use ImmutableList instead.", type);
        return ImmutableList.copyOf((Collection)values);
    }

    private static final class ClassAdapter
    implements JsonSerializer<Class>,
    JsonDeserializer<Class> {
        private ClassAdapter() {
        }

        public JsonElement serialize(Class src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.getName());
        }

        public Class deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return Class.forName(json.getAsJsonPrimitive().getAsString());
            }
            catch (ClassNotFoundException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }
}

