/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.generic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.graph.api.ImmutableGraphContainer;
import org.opennms.netmgt.graph.api.generic.GenericElement;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.api.validation.GraphContainerIdValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericGraphContainer
implements ImmutableGraphContainer<GenericGraph> {
    private final List<GenericGraph> graphs;
    private final Map<String, Object> properties;

    private GenericGraphContainer(GenericGraphContainerBuilder builder) {
        this.properties = ImmutableMap.copyOf((Map)builder.properties);
        this.graphs = ImmutableList.copyOf((Collection)builder.graphs.values().stream().sorted(Comparator.comparing(GenericElement::getNamespace)).collect(Collectors.toList()));
        new GraphContainerIdValidator().validate(this.getId());
    }

    @Override
    public List<GenericGraph> getGraphs() {
        return new ArrayList<GenericGraph>(this.graphs);
    }

    @Override
    public GenericGraph getGraph(String namespace) {
        return this.graphs.stream().filter(g -> g.getNamespace().equals(namespace)).findAny().orElse(null);
    }

    @Override
    public GenericGraphContainer asGenericGraphContainer() {
        return this;
    }

    @Override
    public String getId() {
        return (String)this.properties.get("id");
    }

    @Override
    public List<String> getNamespaces() {
        return this.graphs.stream().map(GenericElement::getNamespace).collect(Collectors.toList());
    }

    @Override
    public String getDescription() {
        return (String)this.properties.get("description");
    }

    public void setDescription(String description) {
        this.properties.put("description", description);
    }

    @Override
    public String getLabel() {
        return (String)this.properties.get("label");
    }

    @Override
    public GraphInfo getGraphInfo(String namespace) {
        Objects.requireNonNull(namespace);
        return this.graphs.stream().filter(g -> g.getNamespace().equals(namespace)).findAny().orElse(null);
    }

    @Override
    public GraphInfo getPrimaryGraphInfo() {
        return this.graphs.get(0);
    }

    @Override
    public List<GraphInfo> getGraphInfos() {
        return new ArrayList<GraphInfo>(this.graphs);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericGraphContainer that = (GenericGraphContainer)o;
        return Objects.equals(this.graphs, that.graphs) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.graphs, this.properties);
    }

    public static GenericGraphContainerBuilder builder() {
        return new GenericGraphContainerBuilder();
    }

    public static class GenericGraphContainerBuilder {
        private static final Logger LOG = LoggerFactory.getLogger(GenericGraphContainerBuilder.class);
        private final Map<String, GenericGraph> graphs = new HashMap<String, GenericGraph>();
        private final Map<String, Object> properties = new HashMap<String, Object>();

        private GenericGraphContainerBuilder() {
        }

        public GenericGraphContainerBuilder id(String id) {
            this.property("id", id);
            return this;
        }

        public GenericGraphContainerBuilder label(String label) {
            this.property("label", label);
            return this;
        }

        public GenericGraphContainerBuilder description(String description) {
            this.property("description", description);
            return this;
        }

        public GenericGraphContainerBuilder property(String name, Object value) {
            if (name == null || value == null) {
                LOG.debug("Property name ({}) or value ({}) is null => ignoring it.", (Object)name, value);
                return this;
            }
            if ("id".equals(name)) {
                new GraphContainerIdValidator().validate((String)value);
            }
            this.properties.put(name, value);
            return this;
        }

        public GenericGraphContainerBuilder properties(Map<String, Object> properties) {
            Objects.requireNonNull(properties, "properties cannot be null");
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                this.property(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public GenericGraphContainerBuilder applyContainerInfo(GraphContainerInfo containerInfo) {
            this.id(containerInfo.getId());
            this.label(containerInfo.getLabel());
            this.description(containerInfo.getDescription());
            return this;
        }

        public GenericGraphContainerBuilder addGraph(GenericGraph graph) {
            Objects.requireNonNull(graph, "Graph cannot be null");
            this.graphs.put(graph.getNamespace(), graph);
            return this;
        }

        public GenericGraphContainer build() {
            return new GenericGraphContainer(this);
        }
    }
}

