/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.hibernate.annotations.BatchSize;
import org.opennms.netmgt.graph.AbstractGraphEntity;
import org.opennms.netmgt.graph.EdgeEntity;
import org.opennms.netmgt.graph.FocusEntity;
import org.opennms.netmgt.graph.VertexEntity;

@Entity
@DiscriminatorValue(value="graph")
public class GraphEntity
extends AbstractGraphEntity {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(name="graph_element_relations", joinColumns={@JoinColumn(name="parent_id", referencedColumnName="id", nullable=false, updatable=true)}, inverseJoinColumns={@JoinColumn(name="child_id", referencedColumnName="id", nullable=false, updatable=true)})
    @BatchSize(size=1000)
    private List<AbstractGraphEntity> relations = new ArrayList<AbstractGraphEntity>();
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="focus_id")
    private FocusEntity defaultFocus;

    public String getDescription() {
        return this.getPropertyValue("description");
    }

    public String getLabel() {
        return this.getPropertyValue("label");
    }

    public List<EdgeEntity> getEdges() {
        return this.getElements(EdgeEntity.class);
    }

    public List<VertexEntity> getVertices() {
        return this.getElements(VertexEntity.class);
    }

    public FocusEntity getDefaultFocus() {
        return this.defaultFocus;
    }

    public void setDefaultFocus(FocusEntity defaultFocus) {
        this.defaultFocus = defaultFocus;
    }

    public VertexEntity getVertexByVertexId(String id) {
        Objects.requireNonNull(id);
        return this.getVertexByProperty("id", id);
    }

    public EdgeEntity getEdgeByProperty(String key, String value) {
        return GraphEntity.getEntitiesByProperty(this.getEdges(), key, value);
    }

    public VertexEntity getVertexByProperty(String key, String value) {
        return GraphEntity.getEntitiesByProperty(this.getVertices(), key, value);
    }

    public <T extends AbstractGraphEntity> void addRelations(List<T> someRelations) {
        this.relations.addAll(someRelations);
    }

    public void addVertex(VertexEntity vertexEntity) {
        this.relations.add(vertexEntity);
    }

    public void removeVertex(VertexEntity vertexEntity) {
        this.relations.remove(vertexEntity);
    }

    public void addEdge(EdgeEntity edgeEntity) {
        this.relations.add(edgeEntity);
    }

    public void removeEdge(EdgeEntity edgeEntity) {
        this.relations.remove(edgeEntity);
    }

    @Transient
    private <T extends AbstractGraphEntity> List<T> getElements(Class<T> type) {
        return Collections.unmodifiableList(this.relations.stream().filter(type::isInstance).map(e -> e).collect(Collectors.toList()));
    }

    private static <E extends AbstractGraphEntity> E getEntitiesByProperty(List<E> entities, String key, String value) {
        return (E)((AbstractGraphEntity)entities.stream().filter(entity -> entity.getProperties().stream().filter(property -> property.getName().equals(key) && property.getValue().equals(value)).findAny().isPresent()).findAny().orElse(null));
    }
}

