/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geolocation.services;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.features.geolocation.api.GeolocationConfiguration;

public class DefaultGeolocationConfiguration
implements GeolocationConfiguration {
    private static final String URL_KEY = "gwt.openlayers.url";
    public static final String OPTIONS_KEY_PREFIX = "gwt.openlayers.options.";

    public DefaultGeolocationConfiguration() {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getTileServerUrl()) ? 1 : 0) != 0, (Object)"System Property 'gwt.openlayers.url' is not defined");
    }

    public String getTileServerUrl() {
        String url = System.getProperty(URL_KEY);
        return DefaultGeolocationConfiguration.sanitize(url);
    }

    public Map<String, String> getOptions() {
        return System.getProperties().keySet().stream().filter(key -> ((String)key).startsWith(OPTIONS_KEY_PREFIX)).map(key -> ((String)key).substring(OPTIONS_KEY_PREFIX.length())).collect(Collectors.toMap(Function.identity(), key -> DefaultGeolocationConfiguration.sanitize(System.getProperty(OPTIONS_KEY_PREFIX + key))));
    }

    private static String sanitize(String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            return input;
        }
        return input.replaceAll("\\$\\{", "{");
    }
}

