/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geolocation.services.status;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opennms.features.geolocation.api.GeolocationQuery;
import org.opennms.features.geolocation.services.status.Status;
import org.opennms.features.geolocation.services.status.StatusCalculator;
import org.opennms.features.geolocation.services.status.Utils;
import org.opennms.netmgt.dao.api.GenericPersistenceAccessor;
import org.opennms.netmgt.model.OnmsSeverity;

public class OutageStatusCalculator
implements StatusCalculator {
    private final GenericPersistenceAccessor genericPersistenceAccessor;

    public OutageStatusCalculator(GenericPersistenceAccessor genericPersistenceAccessor) {
        this.genericPersistenceAccessor = genericPersistenceAccessor;
    }

    @Override
    public Status calculateStatus(GeolocationQuery query, Set<Integer> nodeIds) {
        ArrayList parameterNames = Lists.newArrayList((Object[])new String[]{"nodeIds", "severity"});
        ArrayList parameterValues = Lists.newArrayList((Object[])new Object[]{nodeIds, Utils.getSeverity(query).getId()});
        StringBuilder hql = new StringBuilder();
        hql.append("SELECT node.id, max(event.eventSeverity) ");
        hql.append("FROM OnmsOutage as outage ");
        hql.append("LEFT JOIN outage.monitoredService as ifservice ");
        hql.append("LEFT JOIN ifservice.ipInterface as ipinterface ");
        hql.append("LEFT JOIN ipinterface.node as node ");
        hql.append("LEFT JOIN outage.serviceLostEvent as event ");
        hql.append("WHERE node.id in (:nodeIds) ");
        hql.append("AND outage.serviceRegainedEvent is null ");
        hql.append("AND event.eventSeverity >= :severity ");
        if (query.getLocation() != null) {
            hql.append("AND node.location.locationName = :locationName ");
            parameterNames.add("locationName");
            parameterValues.add(query.getLocation());
        }
        hql.append("GROUP BY node.id");
        List rows = this.genericPersistenceAccessor.findUsingNamedParameters(hql.toString(), parameterNames.toArray(new String[parameterNames.size()]), parameterValues.toArray());
        Status status = new Status();
        for (Object[] eachRow : rows) {
            status.add((Integer)eachRow[0], OnmsSeverity.get((int)((Integer)eachRow[1])), 0L, 0L);
        }
        return status;
    }
}

