/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geolocation.services;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.geocoder.GeocoderException;
import org.opennms.features.geocoder.GeocoderService;
import org.opennms.features.geolocation.api.Coordinates;
import org.opennms.features.geolocation.api.GeolocationResolver;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGeolocationResolver
implements GeolocationResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultGeolocationResolver.class);
    private final GeocoderService geocoderService;
    private final NodeDao nodeDao;

    public DefaultGeolocationResolver(GeocoderService geocoderService, NodeDao nodeDao) {
        this.geocoderService = Objects.requireNonNull(geocoderService);
        this.nodeDao = Objects.requireNonNull(nodeDao);
    }

    public Map<Integer, Coordinates> resolve(Collection<Integer> nodeIds) {
        if (nodeIds == null || nodeIds.isEmpty()) {
            return new HashMap<Integer, Coordinates>();
        }
        Criteria criteria = new CriteriaBuilder(OnmsNode.class).in("id", nodeIds).toCriteria();
        Map<Integer, String> nodeIdAddressMap = this.nodeDao.findMatching(criteria).stream().filter(n -> DefaultGeolocationResolver.getGeoLocation(n) != null).filter(n -> DefaultGeolocationResolver.getGeoLocation(n).getLatitude() == null && DefaultGeolocationResolver.getGeoLocation(n).getLongitude() == null).filter(n -> !Strings.isNullOrEmpty((String)DefaultGeolocationResolver.getGeoLocation(n).asAddressString())).collect(Collectors.toMap(n -> n.getId(), n -> n.getAssetRecord().getGeolocation().asAddressString()));
        return this.resolve(nodeIdAddressMap);
    }

    public Map<Integer, Coordinates> resolve(Map<Integer, String> nodeIdAddressMap) {
        if (nodeIdAddressMap == null || nodeIdAddressMap.isEmpty()) {
            return new HashMap<Integer, Coordinates>();
        }
        nodeIdAddressMap = nodeIdAddressMap.entrySet().stream().filter(e -> !Strings.isNullOrEmpty((String)((String)e.getValue())) && e.getKey() != null).collect(Collectors.toMap(e -> (Integer)e.getKey(), e -> (String)e.getValue()));
        HashMap<Integer, Coordinates> resultMap = new HashMap<Integer, Coordinates>();
        nodeIdAddressMap.entrySet().stream().forEach(entry -> {
            String addressString = (String)entry.getValue();
            Coordinates coordinates = this.resolve(addressString);
            if (coordinates != null) {
                resultMap.put((Integer)entry.getKey(), coordinates);
            }
        });
        return resultMap;
    }

    public Coordinates resolve(String addressString) {
        try {
            org.opennms.features.geocoder.Coordinates coordinates = this.geocoderService.getCoordinates(addressString);
            if (coordinates != null) {
                return new Coordinates(coordinates.getLongitude(), coordinates.getLatitude());
            }
            LOG.warn("Couldn't resolve address '%s'", (Object)addressString);
        }
        catch (GeocoderException e) {
            LOG.warn("Couldn't resolve address '%s'", (Object)addressString, (Object)e);
        }
        return null;
    }

    private static OnmsGeolocation getGeoLocation(OnmsNode node) {
        if (node != null && node.getAssetRecord() != null && node.getAssetRecord().getGeolocation() != null) {
            return node.getAssetRecord().getGeolocation();
        }
        return null;
    }
}

