/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geolocation.services;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.geolocation.api.AddressInfo;
import org.opennms.features.geolocation.api.Coordinates;
import org.opennms.features.geolocation.api.GeolocationInfo;
import org.opennms.features.geolocation.api.GeolocationQuery;
import org.opennms.features.geolocation.api.GeolocationResolver;
import org.opennms.features.geolocation.api.GeolocationService;
import org.opennms.features.geolocation.api.NodeInfo;
import org.opennms.features.geolocation.api.SeverityInfo;
import org.opennms.features.geolocation.api.StatusCalculationStrategy;
import org.opennms.features.geolocation.services.status.AlarmStatusCalculator;
import org.opennms.features.geolocation.services.status.OutageStatusCalculator;
import org.opennms.features.geolocation.services.status.Status;
import org.opennms.features.geolocation.services.status.StatusCalculator;
import org.opennms.netmgt.dao.api.GenericPersistenceAccessor;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGeolocationService
implements GeolocationService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultGeolocationService.class);
    protected static final StatusCalculator NULL_STATUS_CALCULATOR = (theQuery, theNodeIds) -> new Status();
    private GenericPersistenceAccessor genericPersistenceAccessor;
    private GeolocationResolver resolver;

    public DefaultGeolocationService(GenericPersistenceAccessor genericPersistenceAccessor, GeolocationResolver resolver) {
        this.genericPersistenceAccessor = Objects.requireNonNull(genericPersistenceAccessor);
        this.resolver = Objects.requireNonNull(resolver);
    }

    public List<GeolocationInfo> getLocations(GeolocationQuery query) {
        if (query == null) {
            return new ArrayList<GeolocationInfo>();
        }
        List<OnmsNode> nodes = this.getNodes(query);
        List<GeolocationInfo> nodesWithCoordinates = nodes.stream().filter(n -> DefaultGeolocationService.geoLocation(n) != null && DefaultGeolocationService.geoLocation(n).getLongitude() != null && DefaultGeolocationService.geoLocation(n).getLatitude() != null).map(node -> this.convert((OnmsNode)node)).collect(Collectors.toList());
        if (query.getStatusCalculationStrategy() != null) {
            this.applyStatus(query, nodesWithCoordinates);
        }
        if (query.getSeverity() != null) {
            OnmsSeverity severity = OnmsSeverity.get((int)query.getSeverity().getId());
            return nodesWithCoordinates.stream().filter(n -> severity.getId() <= n.getSeverityInfo().getId()).collect(Collectors.toList());
        }
        return nodesWithCoordinates;
    }

    private List<OnmsNode> getNodes(GeolocationQuery query) {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsNode.class).alias("assetRecord", "assetRecord").and(new Restriction[]{Restrictions.isNotNull((String)"assetRecord"), Restrictions.isNotNull((String)"assetRecord.geolocation")});
        if (query.getLocation() != null) {
            criteriaBuilder.and(new Restriction[]{Restrictions.eq((String)"location", (Object)query.getLocation())});
        }
        if (!query.getNodeIds().isEmpty()) {
            criteriaBuilder.in("id", (Collection)query.getNodeIds());
        }
        return this.genericPersistenceAccessor.findMatching(criteriaBuilder.toCriteria());
    }

    private GeolocationInfo convert(OnmsNode node) {
        GeolocationInfo geolocationInfo = new GeolocationInfo();
        OnmsGeolocation onmsGeolocation = DefaultGeolocationService.geoLocation(node);
        if (onmsGeolocation != null) {
            geolocationInfo.setAddressInfo(DefaultGeolocationService.toAddressInfo(onmsGeolocation));
            if (onmsGeolocation.getLongitude() != null && onmsGeolocation.getLatitude() != null) {
                geolocationInfo.setCoordinates(new Coordinates(onmsGeolocation.getLongitude().floatValue(), onmsGeolocation.getLatitude().floatValue()));
            }
        }
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.setNodeId(node.getId().intValue());
        nodeInfo.setNodeLabel(node.getLabel());
        nodeInfo.setNodeLabel(node.getLabel());
        nodeInfo.setForeignSource(node.getForeignSource());
        nodeInfo.setForeignId(node.getForeignId());
        nodeInfo.setLocation(node.getLocation().getLocationName());
        if (node.getAssetRecord() != null) {
            nodeInfo.setDescription(node.getAssetRecord().getDescription());
            nodeInfo.setMaintcontract(node.getAssetRecord().getMaintcontract());
        }
        if (node.getPrimaryInterface() != null) {
            nodeInfo.setIpAddress(InetAddressUtils.str((InetAddress)node.getPrimaryInterface().getIpAddress()));
        }
        nodeInfo.setCategories(node.getCategories().stream().map(c -> c.getName()).collect(Collectors.toList()));
        geolocationInfo.setNodeInfo(nodeInfo);
        return geolocationInfo;
    }

    private void applyStatus(GeolocationQuery query, List<GeolocationInfo> locations) {
        Set<Integer> nodeIds = locations.stream().map(l -> l.getNodeInfo().getNodeId()).collect(Collectors.toSet());
        if (!nodeIds.isEmpty()) {
            StatusCalculator calculator = this.getStatusCalculator(query.getStatusCalculationStrategy());
            Status status = calculator.calculateStatus(query, nodeIds);
            for (GeolocationInfo info : locations) {
                OnmsSeverity severity = status.getSeverity(info.getNodeInfo().getNodeId());
                if (severity == null) {
                    severity = OnmsSeverity.NORMAL;
                }
                info.setSeverityInfo(new SeverityInfo(severity.getId(), severity.getLabel()));
                info.setAlarmUnackedCount(status.getUnacknowledgedAlarmCount(info.getNodeInfo().getNodeId()));
            }
        }
    }

    protected StatusCalculator getStatusCalculator(StatusCalculationStrategy strategy) {
        if (strategy == null) {
            LOG.warn("No strategy defined. Falling back to strategy:{}", (Object)StatusCalculationStrategy.None);
            strategy = StatusCalculationStrategy.None;
        }
        switch (strategy) {
            case Alarms: {
                return new AlarmStatusCalculator(this.genericPersistenceAccessor);
            }
            case Outages: {
                return new OutageStatusCalculator(this.genericPersistenceAccessor);
            }
        }
        return NULL_STATUS_CALCULATOR;
    }

    private static OnmsGeolocation geoLocation(OnmsNode node) {
        if (node != null && node.getAssetRecord() != null && node.getAssetRecord().getGeolocation() != null) {
            return node.getAssetRecord().getGeolocation();
        }
        return null;
    }

    private static AddressInfo toAddressInfo(OnmsGeolocation input) {
        if (input != null) {
            AddressInfo addressInfo = new AddressInfo();
            addressInfo.setAddress1(input.getAddress1());
            addressInfo.setAddress2(input.getAddress2());
            addressInfo.setCity(input.getCity());
            addressInfo.setCountry(input.getCountry());
            addressInfo.setState(input.getState());
            addressInfo.setZip(input.getZip());
            return addressInfo;
        }
        return null;
    }
}

