/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geolocation.services.status;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opennms.features.geolocation.api.GeolocationQuery;
import org.opennms.features.geolocation.services.status.Status;
import org.opennms.features.geolocation.services.status.StatusCalculator;
import org.opennms.features.geolocation.services.status.Utils;
import org.opennms.netmgt.dao.api.GenericPersistenceAccessor;
import org.opennms.netmgt.model.OnmsSeverity;

public class AlarmStatusCalculator
implements StatusCalculator {
    private final GenericPersistenceAccessor genericPersistenceAccessor;

    public AlarmStatusCalculator(GenericPersistenceAccessor genericPersistenceAccessor) {
        this.genericPersistenceAccessor = genericPersistenceAccessor;
    }

    @Override
    public Status calculateStatus(GeolocationQuery query, Set<Integer> nodeIds) {
        ArrayList parameterNames = Lists.newArrayList((Object[])new String[]{"nodeIds", "severity"});
        ArrayList parameterValues = Lists.newArrayList((Object[])new Object[]{nodeIds, Utils.getSeverity(query)});
        StringBuilder hql = new StringBuilder();
        hql.append("SELECT node.id, max(alarm.severity), count(alarm.id), count(alarm.alarmAckTime) ");
        hql.append("FROM OnmsAlarm AS alarm ");
        hql.append("LEFT JOIN alarm.node AS node ");
        hql.append("WHERE node.id IN (:nodeIds) ");
        hql.append("AND alarm.severity >= :severity ");
        if (!query.isIncludeAcknowledgedAlarms()) {
            hql.append("AND alarm.alarmAckTime is null ");
        }
        if (query.getLocation() != null) {
            hql.append("AND node.location.locationName = :nodeLocation ");
            parameterNames.add("nodeLocation");
            parameterValues.add(query.getLocation());
        }
        hql.append("GROUP BY node.id");
        List rows = this.genericPersistenceAccessor.findUsingNamedParameters(hql.toString(), parameterNames.toArray(new String[parameterNames.size()]), parameterValues.toArray());
        Status status = new Status();
        for (Object[] row : rows) {
            status.add((Integer)row[0], (OnmsSeverity)row[1], (Long)row[2], (Long)row[3]);
        }
        return status;
    }
}

