/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geolocation.services.status;

import com.google.common.collect.Maps;
import java.util.Map;
import org.opennms.netmgt.model.OnmsSeverity;

public class Status {
    final Map<Integer, OnmsSeverity> severityMap = Maps.newHashMap();
    final Map<Integer, Long> alarmCountMap = Maps.newHashMap();
    final Map<Integer, Long> unacknowledgedCountMap = Maps.newHashMap();

    public void add(int nodeId, OnmsSeverity severity, long alarmCount, long unacknowledgedCount) {
        this.severityMap.put(nodeId, severity);
        this.alarmCountMap.put(nodeId, alarmCount);
        this.unacknowledgedCountMap.put(nodeId, unacknowledgedCount);
    }

    public OnmsSeverity getSeverity(int nodeId) {
        return this.severityMap.get(nodeId);
    }

    public int getUnacknowledgedAlarmCount(int nodeId) {
        Long value = this.unacknowledgedCountMap.get(nodeId);
        if (value != null) {
            return value.intValue();
        }
        return 0;
    }

    public int size() {
        return this.severityMap.size();
    }
}

