/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.spring.BeanUtils;
import org.opennms.features.geolocation.api.GeolocationConfiguration;
import org.opennms.features.geolocation.api.GeolocationQuery;
import org.opennms.features.geolocation.api.GeolocationService;
import org.opennms.features.geolocation.api.GeolocationSeverity;
import org.opennms.features.geolocation.api.StatusCalculationStrategy;
import org.opennms.features.status.api.node.strategy.NodeStatusCalculationStrategy;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.rest.v2.GeolocationQueryDTO;
import org.opennms.web.rest.v2.InvalidQueryException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="geolocation")
@Transactional
@Produces(value={"application/json", "application/xml", "application/atom+xml"})
@Consumes(value={"application/json", "application/xml", "application/atom+xml"})
public class GeolocationRestService {
    private ServiceRegistry serviceRegistry;

    @POST
    @Path(value="/")
    public Response getLocations(GeolocationQueryDTO queryDTO) {
        GeolocationService service = (GeolocationService)this.getServiceRegistry().findProvider(GeolocationService.class);
        if (service == null) {
            return GeolocationRestService.temporarilyNotAvailable();
        }
        try {
            GeolocationRestService.validate(queryDTO);
            GeolocationQuery query = GeolocationRestService.toQuery(queryDTO);
            List locations = service.getLocations(query);
            if (locations.isEmpty()) {
                return Response.noContent().build();
            }
            return Response.ok((Object)locations).build();
        }
        catch (InvalidQueryException ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ex.getMessage()).build();
        }
    }

    @GET
    @Path(value="/config")
    public Response getConfiguration() {
        GeolocationConfiguration config = (GeolocationConfiguration)this.getServiceRegistry().findProvider(GeolocationConfiguration.class);
        if (config == null) {
            return GeolocationRestService.temporarilyNotAvailable();
        }
        return Response.ok((Object)config).build();
    }

    private ServiceRegistry getServiceRegistry() {
        if (this.serviceRegistry == null) {
            this.serviceRegistry = (ServiceRegistry)BeanUtils.getBean((String)"soaContext", (String)"serviceRegistry", ServiceRegistry.class);
            Objects.requireNonNull(this.serviceRegistry);
        }
        return this.serviceRegistry;
    }

    private static GeolocationQuery toQuery(GeolocationQueryDTO queryDTO) {
        if (queryDTO != null) {
            GeolocationQuery query = new GeolocationQuery();
            if (queryDTO.getSeverityFilter() != null) {
                query.setSeverity((GeolocationSeverity)GeolocationRestService.getEnum(queryDTO.getSeverityFilter(), (Enum[])GeolocationSeverity.values()));
            }
            if (queryDTO.getStrategy() != null) {
                query.setStatusCalculationStrategy((StatusCalculationStrategy)GeolocationRestService.getEnum(queryDTO.getStrategy(), (Enum[])StatusCalculationStrategy.values()));
            }
            query.setIncludeAcknowledgedAlarms(queryDTO.isIncludeAcknowledgedAlarms());
            return query;
        }
        return null;
    }

    private static <T> T getEnum(String input, Enum[] values) {
        for (Enum eachEnum : values) {
            if (!input.equalsIgnoreCase(eachEnum.name())) continue;
            return (T)eachEnum;
        }
        throw new IllegalArgumentException("No enum with value '" + input + "' found in " + Arrays.toString(values));
    }

    private static void validate(GeolocationQueryDTO query) throws InvalidQueryException {
        boolean valid;
        if (query.getStrategy() != null && !(valid = GeolocationRestService.isValid(query.getStrategy(), (Enum[])NodeStatusCalculationStrategy.values()))) {
            throw new InvalidQueryException("Strategy '" + query.getStrategy() + "' is not supported");
        }
        if (query.getSeverityFilter() != null && !(valid = GeolocationRestService.isValid(query.getSeverityFilter(), (Enum[])OnmsSeverity.values()))) {
            throw new InvalidQueryException("Severity ' " + query.getSeverityFilter() + "' is not valid. Supported values are: " + Arrays.toString(OnmsSeverity.values()));
        }
    }

    private static boolean isValid(String input, Enum[] enumValues) {
        for (Enum eachEnum : enumValues) {
            if (!input.equalsIgnoreCase(eachEnum.name())) continue;
            return true;
        }
        return false;
    }

    private static Response temporarilyNotAvailable() {
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"No service registered to handle your query. This is a temporary issue. Please try again later.").build();
    }
}

