/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geolocation.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.opennms.features.geolocation.api.GeolocationQuery;
import org.opennms.features.geolocation.api.GeolocationSeverity;
import org.opennms.features.geolocation.api.StatusCalculationStrategy;

public class GeolocationQueryBuilder {
    private GeolocationQuery query = new GeolocationQuery();

    public GeolocationQueryBuilder withStatusCalculationStrategy(StatusCalculationStrategy statusCalculationStrategy) {
        this.query.setStatusCalculationStrategy(statusCalculationStrategy);
        return this;
    }

    public GeolocationQueryBuilder withLocation(String location) {
        this.query.setLocation(location);
        return this;
    }

    public GeolocationQueryBuilder withIncludeAcknowledgedAlarms(boolean includeAcknowledgedAlarms) {
        this.query.setIncludeAcknowledgedAlarms(includeAcknowledgedAlarms);
        return this;
    }

    public GeolocationQueryBuilder withSeverity(GeolocationSeverity severity) {
        this.query.setSeverity(severity);
        return this;
    }

    public GeolocationQueryBuilder withNodeIds(Integer ... nodeIds) {
        this.withNodeIds(Arrays.asList(nodeIds));
        return this;
    }

    public GeolocationQueryBuilder withNodeIds(Collection<Integer> nodeIds) {
        this.query.setNodeIds(new ArrayList<Integer>(nodeIds));
        return this;
    }

    public GeolocationQueryBuilder withResolveMissingCoordinatesFromAddressString(boolean resolve) {
        this.query.setResolveCoordinatesFromAddressString(resolve);
        return this;
    }

    public GeolocationQuery build() {
        return this.query;
    }
}

