/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geocoder.rest.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.opennms.features.geocoder.GeocoderConfigurationException;
import org.opennms.features.geocoder.GeocoderServiceManager;
import org.opennms.features.geocoder.GeocoderServiceManagerConfiguration;
import org.opennms.features.geocoder.rest.GeocodingRestService;

public class GeocodingRestServiceImpl
implements GeocodingRestService {
    private GeocoderServiceManager geocoderServiceManager;

    public GeocodingRestServiceImpl(GeocoderServiceManager geocoderServiceManager) {
        this.geocoderServiceManager = Objects.requireNonNull(geocoderServiceManager);
    }

    @Override
    public Response getConfiguration() {
        GeocoderServiceManagerConfiguration configuration = this.geocoderServiceManager.getConfiguration();
        Map configurationMap = configuration.asMap();
        JSONObject result = new JSONObject(configurationMap);
        return Response.ok((Object)result.toString()).build();
    }

    @Override
    public Response resetConfiguration() {
        try {
            this.geocoderServiceManager.resetConfiguration();
            return Response.accepted().build();
        }
        catch (IOException ex) {
            return GeocodingRestServiceImpl.createInternalServerErrorResponse(ex);
        }
    }

    @Override
    public Response updateConfiguration(InputStream inputStream) {
        JSONTokener jsonTokener = new JSONTokener(inputStream);
        JSONObject configuration = new JSONObject(jsonTokener);
        Map configurationProperties = configuration.toMap();
        GeocoderServiceManagerConfiguration geocoderServiceManagerConfiguration = new GeocoderServiceManagerConfiguration(configurationProperties);
        try {
            this.geocoderServiceManager.updateConfiguration(geocoderServiceManagerConfiguration);
            return Response.accepted().build();
        }
        catch (IOException ex) {
            return GeocodingRestServiceImpl.createInternalServerErrorResponse(ex);
        }
    }

    @Override
    public Response listGeocoderConfigurations() {
        List services = this.geocoderServiceManager.getGeocoderServices();
        if (services.size() == 0) {
            return Response.noContent().build();
        }
        JSONArray serviceArray = new JSONArray();
        services.stream().forEach(geocoderService -> {
            JSONObject eachService = new JSONObject();
            eachService.put("id", (Object)geocoderService.getId());
            eachService.put("config", geocoderService.getConfiguration().asMap());
            try {
                geocoderService.getConfiguration().validate();
            }
            catch (GeocoderConfigurationException ex) {
                eachService.put("error", (Object)GeocodingRestServiceImpl.createErrorObject(ex));
            }
            serviceArray.put((Object)eachService);
        });
        return Response.ok((Object)serviceArray.toString()).build();
    }

    @Override
    public Response updateGeocoderConfiguration(String geocoderId, InputStream inputStream) {
        try {
            JSONTokener tokener = new JSONTokener(inputStream);
            Map properties = new JSONObject(tokener).getJSONObject("config").toMap();
            try {
                this.geocoderServiceManager.updateGeocoderConfiguration(geocoderId, properties);
            }
            catch (GeocoderConfigurationException ex) {
                JSONObject errorObject = GeocodingRestServiceImpl.createErrorObject(ex);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorObject.toString()).build();
            }
            return Response.noContent().build();
        }
        catch (IOException ex) {
            return GeocodingRestServiceImpl.createInternalServerErrorResponse(ex);
        }
    }

    private static Response createInternalServerErrorResponse(IOException ex) {
        JSONObject errorObject = GeocodingRestServiceImpl.createErrorObject(ex);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errorObject.toString()).build();
    }

    private static JSONObject createErrorObject(Exception ex) {
        return GeocodingRestServiceImpl.createErrorObject(ex.getMessage(), "entity");
    }

    private static JSONObject createErrorObject(GeocoderConfigurationException ex) {
        return GeocodingRestServiceImpl.createErrorObject(ex.getRawMessage(), ex.getContext());
    }

    private static JSONObject createErrorObject(String message, String context) {
        JSONObject errorObject = new JSONObject().put("message", (Object)message).put("context", (Object)context);
        return errorObject;
    }
}

