/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geocoder.nominatim;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.simon04.jelementtree.ElementTree;
import org.apache.commons.io.IOUtils;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.features.geocoder.Coordinates;
import org.opennms.features.geocoder.GeocoderException;
import org.opennms.features.geocoder.GeocoderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NominatimGeocoderService
implements GeocoderService {
    private static final String GEOCODE_URL = "http://open.mapquestapi.com/nominatim/v1/search?format=xml";
    private final HttpClientWrapper m_clientWrapper;
    private String m_emailAddress;
    private String m_referer;
    private boolean m_useSystemProxy = true;
    private Logger m_log = LoggerFactory.getLogger(this.getClass());

    public NominatimGeocoderService() {
        this.m_clientWrapper = HttpClientWrapper.create().dontReuseConnections();
        if (this.m_useSystemProxy) {
            this.m_clientWrapper.useSystemProxySettings();
        }
    }

    public void onInit() {
        if (this.m_emailAddress == null || "".equals(this.m_emailAddress)) {
            throw new UnsupportedOperationException("You must specify an email address for the Nominatim geocoder!");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Coordinates getCoordinates(String address) throws GeocoderException {
        Coordinates coordinates;
        HttpGet method = new HttpGet(this.getUrl(address));
        method.addHeader("User-Agent", "OpenNMS-NominatimGeocoderService/1.0");
        if (this.m_referer != null && !"".equals(this.m_referer)) {
            method.addHeader("Referer", this.m_referer);
        }
        InputStream responseStream = null;
        CloseableHttpResponse response = null;
        try {
            response = this.m_clientWrapper.execute((HttpUriRequest)method);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw new GeocoderException("Nominatim returned a non-OK response code: " + statusLine.getStatusCode() + " " + statusLine.getReasonPhrase());
            }
            responseStream = response.getEntity().getContent();
            ElementTree tree = ElementTree.fromStream((InputStream)responseStream);
            if (tree == null) {
                throw new GeocoderException("an error occurred connecting to the Nominatim geocoding service (no XML tree was found)");
            }
            List places = tree.findAll("//place");
            if (places.size() > 1) {
                this.m_log.warn("More than one location returned for query: {}", (Object)address);
            } else if (places.size() == 0) {
                throw new GeocoderException("Nominatim returned an OK status code, but no places");
            }
            ElementTree place = (ElementTree)places.get(0);
            Float longitude = Float.valueOf(place.getAttribute("lon"));
            Float latitude = Float.valueOf(place.getAttribute("lat"));
            coordinates = new Coordinates(longitude.floatValue(), latitude.floatValue());
        }
        catch (GeocoderException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new GeocoderException("unable to get lon/lat from Nominatim", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(responseStream);
                this.m_clientWrapper.close(response);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)responseStream);
        this.m_clientWrapper.close(response);
        return coordinates;
    }

    private String getUrl(String geolocation) throws GeocoderException {
        try {
            return "http://open.mapquestapi.com/nominatim/v1/search?format=xml&email=" + URLEncoder.encode(geolocation, StandardCharsets.UTF_8.name()) + "&q=" + URLEncoder.encode(geolocation, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new GeocoderException("unable to URL-encode query string", (Throwable)e);
        }
    }

    public String getEmailAddress() {
        return this.m_emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.m_emailAddress = emailAddress;
    }

    public String getReferer() {
        return this.m_referer;
    }

    public void setReferer(String referer) {
        this.m_referer = referer;
    }

    public void setUseSystemProxy(boolean useSystemProxy) {
        this.m_useSystemProxy = useSystemProxy;
    }
}

